/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class EmittersInit<T extends IEmitter, E extends Enum<?>>
extends RelatedUnitsInit<T, E> {
    protected final Map<EntityType<?>, T> entities = new ConcurrentHashMap();
    protected final Optional<Field> ticksRandomly;

    public EmittersInit(ForgeMod mod, Class<E> builtIn) {
        super(mod, builtIn);
        Field field = null;
        try {
            field = ObfuscationReflectionHelper.findField(AbstractBlock.class, (String)"field_149789_z");
            field.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ticksRandomly = Optional.ofNullable(field);
    }

    @Override
    protected void clearAttachedStates() {
        this.entities.clear();
        super.clearAttachedStates();
    }

    @Override
    protected void attachToStates() {
        this.clearAttachedStates();
        for (IEmitter emitter : this.getAll()) {
            if (emitter.getType().isEntity()) {
                EntityType type;
                UnitId id = emitter.getRelatedId();
                if (!ForgeMod.isLoaded(id.getModId()) || (type = (EntityType)ForgeRegistries.ENTITIES.getValue(id.toResLoc())) == null) continue;
                this.entities.put(type, emitter);
                continue;
            }
            this.attachToBlockStates(emitter);
            this.attachToItemStates(emitter);
            this.attachToFluids(emitter);
        }
    }

    @Nullable
    public T findBy(Entity entity) {
        return (T)((IEmitter)this.entities.get(entity.func_200600_R()));
    }

    @Nullable
    public T findBy(IWorldReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        IEmitter emitter = (IEmitter)this.findBy(state);
        if (emitter == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (emitter.isIdentified((INBTSerializable<CompoundNBT>)tile)) {
            return (T)emitter;
        }
        return null;
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
        for (IEmitter unit : this.getAll()) {
            unit.onPostInit();
            BlockStatesSet states = unit.getRelatedId().getAllMatchedBlockStates();
            if (states == null) continue;
            for (Block block : states.getBlocksWithAllStates()) {
                if (block.func_176223_P().func_185904_a() == Material.field_151579_a) continue;
                this.setTicksRandomly((AbstractBlock)block);
            }
            for (BlockState state : states) {
                if (state.func_185904_a() == Material.field_151579_a) continue;
                this.setTicksRandomly((AbstractBlock)state.func_177230_c());
            }
        }
    }

    protected void setTicksRandomly(AbstractBlock block) {
        if (this.ticksRandomly.isPresent()) {
            try {
                this.ticksRandomly.get().set(block, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

