/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.api.enums;

import java.util.Locale;

public enum Metal {
    IRON(true),
    STEEL,
    TIN,
    PEWTER,
    ZINC,
    BRASS,
    COPPER,
    BRONZE,
    ALUMINUM,
    DURALUMIN,
    CHROMIUM,
    NICROSIL,
    GOLD(true),
    ELECTRUM,
    CADMIUM,
    BENDALLOY;

    private final boolean vanilla;

    public boolean isVanilla() {
        return this.vanilla;
    }

    private Metal() {
        this(false);
    }

    private Metal(boolean isVanilla) {
        this.vanilla = isVanilla;
    }

    public static Metal getMetal(int index) {
        for (Metal metal : Metal.values()) {
            if (metal.getIndex() != index) continue;
            return metal;
        }
        throw new IllegalArgumentException("Allomancy: Bad Metal Index");
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public int getIndex() {
        return this.ordinal();
    }
}

