/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.extras.block.IronButtonBlock;
import com.legobmw99.allomancy.modules.extras.block.IronLeverBlock;
import com.legobmw99.allomancy.modules.materials.MaterialsSetup;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.singleTextureBlock((Block)MaterialsSetup.ALUMINUM_ORE.get(), "aluminum_ore", "block/aluminum_ore");
        this.singleTextureBlock((Block)MaterialsSetup.CADMIUM_ORE.get(), "cadmium_ore", "block/cadmium_ore");
        this.singleTextureBlock((Block)MaterialsSetup.CHROMIUM_ORE.get(), "chromium_ore", "block/chromium_ore");
        this.singleTextureBlock((Block)MaterialsSetup.COPPER_ORE.get(), "copper_ore", "block/copper_ore");
        this.singleTextureBlock((Block)MaterialsSetup.LEAD_ORE.get(), "lead_ore", "block/lead_ore");
        this.singleTextureBlock((Block)MaterialsSetup.SILVER_ORE.get(), "silver_ore", "block/silver_ore");
        this.singleTextureBlock((Block)MaterialsSetup.TIN_ORE.get(), "tin_ore", "block/tin_ore");
        this.singleTextureBlock((Block)MaterialsSetup.ZINC_ORE.get(), "zinc_ore", "block/zinc_ore");
        for (RegistryObject<Block> rblock : MaterialsSetup.STORAGE_BLOCKS) {
            if (rblock == null) continue;
            Block block = (Block)rblock.get();
            String path = block.getRegistryName().func_110623_a();
            this.singleTextureBlock(block, path, "block/" + path);
        }
        this.createIronLeverBlock();
        this.createIronButtonBlock();
    }

    private void singleTextureBlock(Block block, String model, String texture) {
        Allomancy.LOGGER.debug("Creating Block Data for " + block.getRegistryName());
        this.simpleBlock(block);
    }

    private void createIronButtonBlock() {
        Allomancy.LOGGER.debug("Creating Block Data for allomancy:iron_button");
        ModelBuilder inventory = ((BlockModelBuilder)this.models().withExistingParent("allomancy:iron_button_inventory", this.mcLoc("block/button_inventory"))).texture("texture", this.mcLoc("block/iron_block"));
        ModelBuilder button = ((BlockModelBuilder)this.models().withExistingParent("allomancy:iron_button", this.mcLoc("block/button"))).texture("texture", this.mcLoc("block/iron_block"));
        ModelBuilder pressed = ((BlockModelBuilder)this.models().withExistingParent("allomancy:iron_button_pressed", this.mcLoc("block/button_pressed"))).texture("texture", this.mcLoc("block/iron_block"));
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)ExtrasSetup.IRON_BUTTON.get());
        for (Boolean powered : IronButtonBlock.field_176584_b.func_177700_c()) {
            ModelBuilder model = powered != false ? pressed : button;
            for (AttachFace face : IronButtonBlock.field_196366_M.func_177700_c()) {
                int xangle = face == AttachFace.CEILING ? 180 : (face == AttachFace.WALL ? 90 : 0);
                boolean uvlock = face == AttachFace.WALL;
                for (Direction dir : IronButtonBlock.field_185512_D.func_177700_c()) {
                    int yangle = (int)dir.func_185119_l();
                    yangle = face != AttachFace.CEILING ? (yangle + 180) % 360 : yangle;
                    builder.partialState().with((Property)IronButtonBlock.field_176584_b, (Comparable)powered).with((Property)IronButtonBlock.field_196366_M, (Comparable)face).with((Property)IronButtonBlock.field_185512_D, (Comparable)dir).modelForState().modelFile((ModelFile)model).uvLock(uvlock).rotationY(yangle).rotationX(xangle).addModel();
                }
            }
        }
    }

    private void createIronLeverBlock() {
        Allomancy.LOGGER.debug("Creating Block Data for allomancy:iron_lever");
        BiConsumer<Direction, ModelBuilder.ElementBuilder.FaceBuilder> base_generator = (dir, facebuilder) -> {
            switch (dir) {
                case UP: {
                    facebuilder.uvs(5.0f, 4.0f, 11.0f, 12.0f).texture("#base").end();
                    break;
                }
                case DOWN: {
                    facebuilder.uvs(5.0f, 4.0f, 11.0f, 12.0f).texture("#base").cullface(Direction.DOWN).end();
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    facebuilder.uvs(5.0f, 0.0f, 11.0f, 3.0f).texture("#base").end();
                    break;
                }
                case WEST: 
                case EAST: {
                    facebuilder.uvs(4.0f, 0.0f, 12.0f, 3.0f).texture("#base").end();
                }
            }
        };
        BiConsumer<Direction, ModelBuilder.ElementBuilder.FaceBuilder> lever_generator = (dir, facebuilder) -> {
            switch (dir) {
                case UP: {
                    facebuilder.uvs(7.0f, 6.0f, 9.0f, 8.0f).texture("#lever").end();
                    break;
                }
                case NORTH: 
                case SOUTH: 
                case WEST: 
                case EAST: {
                    facebuilder.uvs(7.0f, 6.0f, 9.0f, 16.0f).texture("#lever").end();
                    break;
                }
                case DOWN: {
                    facebuilder.end();
                }
            }
        };
        ModelBuilder lever_on = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("allomancy:iron_lever")).ao(false)).texture("particle", this.mcLoc("block/iron_block"))).texture("base", this.mcLoc("block/iron_block"))).texture("lever", this.modLoc("block/iron_lever"))).element().from(5.0f, 0.0f, 4.0f).to(11.0f, 3.0f, 12.0f).allFaces(base_generator).end()).element().from(7.0f, 1.0f, 7.0f).to(9.0f, 11.0f, 9.0f).rotation().origin(8.0f, 1.0f, 8.0f).axis(Direction.Axis.X).angle(-45.0f).end().allFaces(lever_generator).end();
        ModelBuilder lever_off = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("allomancy:iron_lever_off")).ao(false)).texture("particle", this.mcLoc("block/iron_block"))).texture("base", this.mcLoc("block/iron_block"))).texture("lever", this.modLoc("block/iron_lever"))).element().from(5.0f, 0.0f, 4.0f).to(11.0f, 3.0f, 12.0f).allFaces(base_generator).end()).element().from(7.0f, 1.0f, 7.0f).to(9.0f, 11.0f, 9.0f).rotation().origin(8.0f, 1.0f, 8.0f).axis(Direction.Axis.X).angle(45.0f).end().allFaces(lever_generator).end();
        VariantBlockStateBuilder builder = this.getVariantBuilder((Block)ExtrasSetup.IRON_LEVER.get());
        for (Boolean powered : IronLeverBlock.field_176359_b.func_177700_c()) {
            ModelBuilder model = powered != false ? lever_on : lever_off;
            for (AttachFace face : IronLeverBlock.field_196366_M.func_177700_c()) {
                int xangle = face == AttachFace.CEILING ? 180 : (face == AttachFace.WALL ? 90 : 0);
                for (Direction dir2 : IronLeverBlock.field_185512_D.func_177700_c()) {
                    int yangle = (int)dir2.func_185119_l();
                    yangle = face != AttachFace.CEILING ? (yangle + 180) % 360 : yangle;
                    builder.partialState().with((Property)IronLeverBlock.field_176359_b, (Comparable)powered).with((Property)IronLeverBlock.field_196366_M, (Comparable)face).with((Property)IronLeverBlock.field_185512_D, (Comparable)dir2).modelForState().modelFile((ModelFile)model).rotationY(yangle).rotationX(xangle).addModel();
                }
            }
        }
    }

    public String func_200397_b() {
        return "Allomancy Blockstates";
    }
}

