/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.materials.MaterialsSetup;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraftforge.common.data.LanguageProvider;

public class Languages
extends LanguageProvider {
    public Languages(DataGenerator gen, String modid, String locale) {
        super(gen, modid, locale);
    }

    private static String getDisplayName(Metal mt) {
        return Languages.toTitleCase(mt.getName());
    }

    private static String toTitleCase(String in) {
        return in.substring(0, 1).toUpperCase() + in.substring(1);
    }

    protected void addTranslations() {
        this.add("itemGroup.allomancy", "Allomancy");
        for (Metal metal : Metal.values()) {
            this.add("metals." + metal.getName(), Languages.getDisplayName(metal));
        }
        this.add((Block)MaterialsSetup.ALUMINUM_ORE.get(), "Aluminum Ore");
        this.add((Block)MaterialsSetup.CADMIUM_ORE.get(), "Cadmium Ore");
        this.add((Block)MaterialsSetup.CHROMIUM_ORE.get(), "Chromium Ore");
        this.add((Block)MaterialsSetup.COPPER_ORE.get(), "Copper Ore");
        this.add((Block)MaterialsSetup.LEAD_ORE.get(), "Lead Ore");
        this.add((Block)MaterialsSetup.SILVER_ORE.get(), "Silver Ore");
        this.add((Block)MaterialsSetup.TIN_ORE.get(), "Tin Ore");
        this.add((Block)MaterialsSetup.ZINC_ORE.get(), "Zinc Ore");
        this.add((Block)ExtrasSetup.IRON_BUTTON.get(), "Iron Button");
        this.add((Block)ExtrasSetup.IRON_LEVER.get(), "Iron Lever");
        this.add("block.allomancy.iron_activation.lore", "This item seems too heavy to activate by ordinary means");
        this.add((Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), "Hand Grinder");
        this.add((Item)ConsumeSetup.LERASIUM_NUGGET.get(), "Lerasium Nugget");
        this.add("item.allomancy.lerasium_nugget.lore", "This item is endowed with strange powers, perhaps you should ingest it?");
        this.add((Item)CombatSetup.MISTCLOAK.get(), "Mistcloak");
        this.add((Item)CombatSetup.COIN_BAG.get(), "Coin Bag");
        this.add((Item)CombatSetup.OBSIDIAN_DAGGER.get(), "Obsidian Dagger");
        this.add((Item)CombatSetup.KOLOSS_BLADE.get(), "Koloss Blade");
        this.add("item.allomancy.koloss_blade.lore", "This item is too heavy for the average person to wield.");
        this.add((Item)ConsumeSetup.VIAL.get(), "Allomantic Vial");
        this.add("item.allomancy.vial.lore_count", "Contains %d metals");
        this.add("item.allomancy.vial.lore_inst", "Hold SHIFT to view");
        for (Metal metal : Metal.values()) {
            this.add((Item)MaterialsSetup.FLAKES.get(metal.getIndex()).get(), Languages.getDisplayName(metal) + " Flakes");
            this.add((Item)ExtrasSetup.PATTERN_ITEMS.get(metal.getIndex()).get(), "Banner Pattern");
            this.add("item.allomancy." + metal.getName() + "_pattern.desc", Languages.getDisplayName(metal) + " Symbol");
            if (metal.isVanilla()) continue;
            this.add((Item)MaterialsSetup.NUGGETS.get(metal.getIndex()).get(), Languages.getDisplayName(metal) + " Nugget");
            this.add((Item)MaterialsSetup.INGOTS.get(metal.getIndex()).get(), Languages.getDisplayName(metal) + " Ingot");
            this.add((Block)MaterialsSetup.STORAGE_BLOCKS.get(metal.getIndex()).get(), Languages.getDisplayName(metal) + " Block");
        }
        this.add((Item)MaterialsSetup.FLAKES.get(MaterialsSetup.LEAD).get(), "Lead Flakes");
        this.add((Item)MaterialsSetup.NUGGETS.get(MaterialsSetup.LEAD).get(), "Lead Nugget");
        this.add((Item)MaterialsSetup.INGOTS.get(MaterialsSetup.LEAD).get(), "Lead Ingot");
        this.add((Block)MaterialsSetup.STORAGE_BLOCKS.get(MaterialsSetup.LEAD).get(), "Lead Block");
        this.add((Item)MaterialsSetup.FLAKES.get(MaterialsSetup.SILVER).get(), "Silver Flakes");
        this.add((Item)MaterialsSetup.NUGGETS.get(MaterialsSetup.SILVER).get(), "Silver Nugget");
        this.add((Item)MaterialsSetup.INGOTS.get(MaterialsSetup.SILVER).get(), "Silver Ingot");
        this.add((Block)MaterialsSetup.STORAGE_BLOCKS.get(MaterialsSetup.SILVER).get(), "Silver Block");
        this.add((EntityType)CombatSetup.NUGGET_PROJECTILE.get(), "Nugget Projectile");
        this.add("advancements.become_mistborn.title", "Become Mistborn!");
        this.add("advancements.become_mistborn.desc", "You have a power most people envy...");
        this.add("key.categories.allomancy", "Allomancy");
        this.add("key.burn", "Burn Metals");
        this.add("key.hud", "Show HUD");
        this.add("commands.allomancy.getpowers", "%s currently has Allomantic powers: %s");
        this.add("commands.allomancy.addpower", "%s added Allomantic power %s");
        this.add("commands.allomancy.removepower", "%s removed Allomantic power %s");
        this.add("commands.allomancy.unrecognized", "Unrecognized Allomancy power: '%s'");
        this.add("commands.allomancy.err_add", "Unable to add power %s, already had");
        this.add("commands.allomancy.err_remove", "Unable to remove power %s, did not have");
        for (Metal metal : DyeColor.values()) {
            for (Metal mt : Metal.values()) {
                this.add("block.minecraft.banner.allomancy_" + mt.getName() + "." + metal.func_176762_d(), this.getDisplayName((DyeColor)metal) + " " + Languages.getDisplayName(mt) + " Symbol");
            }
        }
    }

    public String func_200397_b() {
        return "Allomancy Language";
    }

    private String getDisplayName(DyeColor color) {
        String[] trans = color.func_176762_d().split("_");
        return Arrays.stream(trans).map(Languages::toTitleCase).collect(Collectors.joining(" "));
    }
}

