/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.datagen;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.extras.ExtrasSetup;
import com.legobmw99.allomancy.modules.materials.MaterialsSetup;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.CustomRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;

public class Recipes
extends RecipeProvider {
    private final Map<Character, Ingredient> defaultIngredients = new HashMap<Character, Ingredient>();

    public Recipes(DataGenerator generatorIn) {
        super(generatorIn);
        this.add('i', (ITag.INamedTag<Item>)Tags.Items.INGOTS_IRON);
        this.add('g', (ITag.INamedTag<Item>)Tags.Items.INGOTS_GOLD);
        this.add('s', (IItemProvider)Items.field_151055_y);
        this.add('S', (ITag.INamedTag<Item>)ItemTags.field_202899_i);
        this.add('G', (IItemProvider)Items.field_221650_am);
        this.add('I', (ITag.INamedTag<Item>)Tags.Items.STORAGE_BLOCKS_IRON);
        this.add('W', (IItemProvider)Items.field_221610_aL);
        this.add('O', (ITag.INamedTag<Item>)Tags.Items.OBSIDIAN);
        this.add('C', (IItemProvider)Items.field_221585_m);
    }

    protected static void buildShapeless(Consumer<IFinishedRecipe> consumer, IItemProvider result, int count, Item criterion, Ingredient ... ingredients) {
        Recipes.buildShapeless(consumer, result, count, criterion, "", ingredients);
    }

    protected static void buildShapeless(Consumer<IFinishedRecipe> consumer, IItemProvider result, int count, Item criterion, String save, Ingredient ... ingredients) {
        Allomancy.LOGGER.debug("Creating Shapeless Recipe for " + result.func_199767_j().getRegistryName() + " " + save);
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.func_200488_a((IItemProvider)result, (int)count);
        builder.func_200483_a("has_" + criterion.getRegistryName().func_110623_a(), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{criterion}));
        for (Ingredient ingredient : ingredients) {
            builder.func_200489_a(ingredient);
        }
        if (save.isEmpty()) {
            builder.func_200482_a(consumer);
        } else {
            builder.func_200484_a(consumer, save);
        }
    }

    protected static void buildSmeltingAndBlasting(Consumer<IFinishedRecipe> consumer, IItemProvider result, IItemProvider ingredient, float xp) {
        Allomancy.LOGGER.debug("Creating Smelting and Blasting Recipe for " + result.func_199767_j().getRegistryName());
        CookingRecipeBuilder smelt = CookingRecipeBuilder.func_218629_c((Ingredient)Recipes.ing(ingredient), (IItemProvider)result, (float)xp, (int)200);
        CookingRecipeBuilder blast = CookingRecipeBuilder.func_218633_b((Ingredient)Recipes.ing(ingredient), (IItemProvider)result, (float)xp, (int)100);
        smelt.func_218628_a("has_" + ingredient.func_199767_j().getRegistryName().func_110623_a(), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{ingredient}));
        blast.func_218628_a("has_" + ingredient.func_199767_j().getRegistryName().func_110623_a(), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{ingredient}));
        smelt.func_218630_a(consumer);
        blast.func_218632_a(consumer, result.func_199767_j().getRegistryName() + "_from_blasting");
    }

    private static String mixing_save(String metal) {
        return "allomancy:" + metal + "_flakes_from_mixing";
    }

    private static String alloy_save(String metal) {
        return "allomancy:" + metal + "_ingot_from_alloying";
    }

    protected static Ingredient ing(String tag) {
        return Ingredient.func_199805_a((ITag)ItemTags.func_199901_a((String)tag));
    }

    protected static Ingredient ing(ITag.INamedTag<Item> tag) {
        return Ingredient.func_199805_a(tag);
    }

    protected static Ingredient ing(IItemProvider itemProvider) {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemProvider});
    }

    protected static Ingredient ing(Ingredient ingredient) {
        return ingredient;
    }

    protected static Ingredient[] repeat(Ingredient ing, int n) {
        return Recipes.repeatWith(ing, n, new Ingredient[0]);
    }

    protected static Ingredient[] repeatWith(Ingredient ing, int n, Ingredient ... extras) {
        int size = n + extras.length;
        Ingredient[] out = new Ingredient[size];
        for (int i = 0; i < n; ++i) {
            out[i] = ing;
        }
        if (extras.length > 0) {
            System.arraycopy(extras, 0, out, n, size - n);
        }
        return out;
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.buildShaped(consumer, (IItemProvider)ExtrasSetup.IRON_LEVER.get(), Items.field_151042_j, "s", "I");
        this.buildShaped(consumer, (IItemProvider)ExtrasSetup.IRON_BUTTON.get(), Items.field_151042_j, "i", "I");
        this.buildShaped(consumer, (IItemProvider)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Items.field_151042_j, "ggg", "iii", "ggg");
        this.buildShaped(consumer, (IItemProvider)ConsumeSetup.VIAL.get(), 4, Items.field_221650_am, " S ", "G G", " G ");
        this.buildShaped(consumer, (IItemProvider)CombatSetup.MISTCLOAK.get(), (Item)ConsumeSetup.VIAL.get(), "W W", "WWW", "WWW");
        this.buildShaped(consumer, (IItemProvider)CombatSetup.OBSIDIAN_DAGGER.get(), (Item)CombatSetup.MISTCLOAK.get(), "  O", " O ", "s  ");
        this.buildShaped(consumer, (IItemProvider)CombatSetup.KOLOSS_BLADE.get(), (Item)ConsumeSetup.LERASIUM_NUGGET.get(), "CC", "CC", "sC");
        Recipes.buildSmeltingAndBlasting(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.ALUMINUM.getIndex()).get(), (IItemProvider)MaterialsSetup.ALUMINUM_ORE.get(), 0.6f);
        Recipes.buildSmeltingAndBlasting(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.CADMIUM.getIndex()).get(), (IItemProvider)MaterialsSetup.CADMIUM_ORE.get(), 0.7f);
        Recipes.buildSmeltingAndBlasting(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.CHROMIUM.getIndex()).get(), (IItemProvider)MaterialsSetup.CHROMIUM_ORE.get(), 0.7f);
        Recipes.buildSmeltingAndBlasting(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.COPPER.getIndex()).get(), (IItemProvider)MaterialsSetup.COPPER_ORE.get(), 0.8f);
        Recipes.buildSmeltingAndBlasting(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.TIN.getIndex()).get(), (IItemProvider)MaterialsSetup.TIN_ORE.get(), 0.6f);
        Recipes.buildSmeltingAndBlasting(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.ZINC.getIndex()).get(), (IItemProvider)MaterialsSetup.ZINC_ORE.get(), 0.6f);
        Recipes.buildSmeltingAndBlasting(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(MaterialsSetup.LEAD).get(), (IItemProvider)MaterialsSetup.LEAD_ORE.get(), 0.4f);
        Recipes.buildSmeltingAndBlasting(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(MaterialsSetup.SILVER).get(), (IItemProvider)MaterialsSetup.SILVER_ORE.get(), 1.0f);
        Recipes.buildShapeless(consumer, (IItemProvider)ConsumeSetup.LERASIUM_NUGGET.get(), 1, Items.field_151156_bN, Recipes.ing((IItemProvider)Items.field_151156_bN), Recipes.ing((ITag.INamedTag<Item>)Tags.Items.STORAGE_BLOCKS_GOLD));
        for (int i = 0; i < MaterialsSetup.METAL_ITEM_LEN; ++i) {
            Item flake = (Item)MaterialsSetup.FLAKES.get(i).get();
            String flakeType = flake.getRegistryName().func_110623_a().substring(0, flake.getRegistryName().func_110623_a().indexOf(95));
            Recipes.buildShapeless(consumer, (IItemProvider)flake, 2, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.ing((IItemProvider)ConsumeSetup.ALLOMANTIC_GRINDER.get()), Recipes.ing("forge:ingots/" + flakeType));
            if (i < Metal.values().length && Metal.getMetal(i).isVanilla()) continue;
            Item block = (Item)MaterialsSetup.STORAGE_BLOCK_ITEMS.get(i).get();
            Item ingot = (Item)MaterialsSetup.INGOTS.get(i).get();
            Item nugget = (Item)MaterialsSetup.NUGGETS.get(i).get();
            Recipes.buildShapeless(consumer, (IItemProvider)block, 1, ingot, Recipes.repeat(Recipes.ing((IItemProvider)ingot), 9));
            Recipes.buildShapeless(consumer, (IItemProvider)ingot, 1, nugget, "allomancy:" + ingot.getRegistryName().func_110623_a() + "_from_nuggets", Recipes.repeat(Recipes.ing((IItemProvider)nugget), 9));
            Recipes.buildShapeless(consumer, (IItemProvider)ingot, 9, block, "allomancy:" + ingot.getRegistryName().func_110623_a() + "_from_block", Recipes.ing((IItemProvider)block));
            Recipes.buildShapeless(consumer, (IItemProvider)nugget, 9, ingot, Recipes.ing((IItemProvider)ingot));
        }
        for (Metal mt : Metal.values()) {
            Recipes.buildShapeless(consumer, (IItemProvider)ExtrasSetup.PATTERN_ITEMS.get(mt.getIndex()).get(), 1, (Item)MaterialsSetup.FLAKES.get(mt.getIndex()).get(), Recipes.ing((IItemProvider)Items.field_151121_aF), Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(mt.getIndex()).get()));
        }
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.FLAKES.get(Metal.STEEL.getIndex()).get(), 2, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("steel"), Recipes.ing((IItemProvider)Items.field_151044_h), Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(Metal.IRON.getIndex()).get()));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.FLAKES.get(Metal.PEWTER.getIndex()).get(), 3, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("pewter"), Recipes.repeatWith(Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(Metal.TIN.getIndex()).get()), 2, Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(MaterialsSetup.LEAD).get())));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.FLAKES.get(Metal.BRASS.getIndex()).get(), 4, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("brass"), Recipes.repeatWith(Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(Metal.COPPER.getIndex()).get()), 3, Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(Metal.ZINC.getIndex()).get())));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.FLAKES.get(Metal.BRONZE.getIndex()).get(), 4, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("bronze"), Recipes.repeatWith(Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(Metal.COPPER.getIndex()).get()), 3, Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(Metal.TIN.getIndex()).get())));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.FLAKES.get(Metal.DURALUMIN.getIndex()).get(), 4, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("duralumin"), Recipes.repeatWith(Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(Metal.ALUMINUM.getIndex()).get()), 3, Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(Metal.COPPER.getIndex()).get())));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.FLAKES.get(Metal.ELECTRUM.getIndex()).get(), 2, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("electrum"), Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(Metal.GOLD.getIndex()).get()), Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(MaterialsSetup.SILVER).get()));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.FLAKES.get(Metal.BENDALLOY.getIndex()).get(), 3, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("bendalloy"), Recipes.repeatWith(Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(Metal.CADMIUM.getIndex()).get()), 2, Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(MaterialsSetup.LEAD).get())));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.FLAKES.get(Metal.NICROSIL.getIndex()).get(), 4, (Item)ConsumeSetup.ALLOMANTIC_GRINDER.get(), Recipes.mixing_save("nicrosil"), Recipes.repeatWith(Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(Metal.CHROMIUM.getIndex()).get()), 3, Recipes.ing((IItemProvider)MaterialsSetup.FLAKES.get(Metal.IRON.getIndex()).get())));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.STEEL.getIndex()).get(), 4, Items.field_151044_h, Recipes.alloy_save("steel"), Recipes.repeatWith(Recipes.ing((IItemProvider)Items.field_151042_j), 3, Recipes.ing((IItemProvider)Items.field_151044_h)));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.PEWTER.getIndex()).get(), 3, (Item)MaterialsSetup.INGOTS.get(Metal.TIN.getIndex()).get(), Recipes.alloy_save("pewter"), Recipes.repeatWith(Recipes.ing("forge:ingots/tin"), 2, Recipes.ing("forge:ingots/lead")));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.BRASS.getIndex()).get(), 4, (Item)MaterialsSetup.INGOTS.get(Metal.COPPER.getIndex()).get(), Recipes.alloy_save("brass"), Recipes.repeatWith(Recipes.ing("forge:ingots/copper"), 3, Recipes.ing("forge:ingots/zinc")));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.BRONZE.getIndex()).get(), 4, (Item)MaterialsSetup.INGOTS.get(Metal.COPPER.getIndex()).get(), Recipes.alloy_save("bronze"), Recipes.repeatWith(Recipes.ing("forge:ingots/copper"), 3, Recipes.ing("forge:ingots/tin")));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.DURALUMIN.getIndex()).get(), 4, (Item)MaterialsSetup.INGOTS.get(Metal.ALUMINUM.getIndex()).get(), Recipes.alloy_save("duralumin"), Recipes.repeatWith(Recipes.ing("forge:ingots/aluminum"), 3, Recipes.ing("forge:ingots/copper")));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.ELECTRUM.getIndex()).get(), 2, (Item)MaterialsSetup.INGOTS.get(MaterialsSetup.SILVER).get(), Recipes.alloy_save("electrum"), Recipes.ing("forge:ingots/silver"), Recipes.ing((IItemProvider)Items.field_151043_k));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.BENDALLOY.getIndex()).get(), 3, (Item)MaterialsSetup.INGOTS.get(Metal.CADMIUM.getIndex()).get(), Recipes.alloy_save("bendalloy"), Recipes.repeatWith(Recipes.ing("forge:ingots/cadmium"), 2, Recipes.ing("forge:ingots/lead")));
        Recipes.buildShapeless(consumer, (IItemProvider)MaterialsSetup.INGOTS.get(Metal.NICROSIL.getIndex()).get(), 4, (Item)MaterialsSetup.INGOTS.get(Metal.CHROMIUM.getIndex()).get(), Recipes.alloy_save("nicrosil"), Recipes.repeatWith(Recipes.ing("forge:ingots/chromium"), 3, Recipes.ing((IItemProvider)Items.field_151042_j)));
        Allomancy.LOGGER.debug("Creating Shaped Recipe for allomancy:coin_bag");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)CombatSetup.COIN_BAG.get())).func_200465_a("has_gold_nugget", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)CombatSetup.MISTCLOAK.get()})).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151058_ca).func_200462_a(Character.valueOf('l'), (IItemProvider)Items.field_151116_aA).func_200462_a(Character.valueOf('g'), (IItemProvider)Items.field_151074_bl).func_200472_a(" #g").func_200472_a("l l").func_200472_a(" l ").func_200464_a(consumer);
        Allomancy.LOGGER.debug("Creating Special Recipe for Vial Filling");
        CustomRecipeBuilder.func_218656_a((SpecialRecipeSerializer)((SpecialRecipeSerializer)ConsumeSetup.VIAL_RECIPE_SERIALIZER.get())).func_200499_a(consumer, "allomancy:vial_filling_recipe");
    }

    protected void buildShaped(Consumer<IFinishedRecipe> consumer, IItemProvider result, int count, Item criterion, String ... lines) {
        Allomancy.LOGGER.debug("Creating Shaped Recipe for " + result.func_199767_j().getRegistryName());
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.func_200468_a((IItemProvider)result, (int)count);
        builder.func_200465_a("has_" + criterion.getRegistryName().func_110623_a(), (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{criterion}));
        HashSet characters = new HashSet();
        for (String line : lines) {
            builder.func_200472_a(line);
            line.chars().forEach(value -> characters.add(Character.valueOf((char)value)));
        }
        for (Character c : characters) {
            if (!this.defaultIngredients.containsKey(c)) continue;
            builder.func_200471_a(c, this.defaultIngredients.get(c));
        }
        builder.func_200464_a(consumer);
    }

    protected void buildShaped(Consumer<IFinishedRecipe> consumer, IItemProvider result, Item criterion, String ... lines) {
        this.buildShaped(consumer, result, 1, criterion, lines);
    }

    protected void add(char c, ITag.INamedTag<Item> itemTag) {
        this.defaultIngredients.put(Character.valueOf(c), Ingredient.func_199805_a(itemTag));
    }

    protected void add(char c, IItemProvider itemProvider) {
        this.defaultIngredients.put(Character.valueOf(c), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemProvider}));
    }

    protected void add(char c, Ingredient ingredient) {
        this.defaultIngredients.put(Character.valueOf(c), ingredient);
    }

    public String func_200397_b() {
        return "Allomancy Recipes";
    }
}

