/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.consumables.item.recipe;

import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.materials.MaterialsSetup;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public class VialItemRecipe
extends SpecialRecipe {
    private static final Ingredient INGREDIENT_FLAKES = Ingredient.func_199804_a((IItemProvider[])((IItemProvider[])MaterialsSetup.FLAKES.subList(0, Metal.values().length).stream().map(RegistryObject::get).toArray(Item[]::new)));
    private static final Ingredient INGREDIENT_VIAL = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ConsumeSetup.VIAL.get()});
    private ItemStack item_result = ItemStack.field_190927_a;

    public VialItemRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        this.item_result = ItemStack.field_190927_a;
        boolean[] metals = new boolean[Metal.values().length];
        Arrays.fill(metals, false);
        boolean[] ingredients = new boolean[]{false, false};
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            Metal mt;
            int n;
            int n2;
            Metal[] metalArray;
            ItemStack itemstack = inv.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            if (INGREDIENT_FLAKES.test(itemstack)) {
                metalArray = Metal.values();
                n2 = metalArray.length;
                for (n = 0; n < n2; ++n) {
                    mt = metalArray[n];
                    if (itemstack.func_77973_b() != MaterialsSetup.FLAKES.get(mt.getIndex()).get()) continue;
                    if (metals[mt.getIndex()]) {
                        return false;
                    }
                    metals[mt.getIndex()] = true;
                    ingredients[1] = true;
                }
                continue;
            }
            if (INGREDIENT_VIAL.test(itemstack)) {
                if (itemstack.func_77978_p() != null) {
                    metalArray = Metal.values();
                    n2 = metalArray.length;
                    for (n = 0; n < n2; ++n) {
                        mt = metalArray[n];
                        if (!itemstack.func_77978_p().func_74764_b(mt.getName())) continue;
                        boolean hasMetalAlready = itemstack.func_77978_p().func_74767_n(mt.getName());
                        if (metals[mt.getIndex()] && hasMetalAlready) {
                            return false;
                        }
                        metals[mt.getIndex()] = metals[mt.getIndex()] || hasMetalAlready;
                    }
                }
                ingredients[0] = true;
                continue;
            }
            return false;
        }
        if (ingredients[0] && ingredients[1]) {
            this.item_result = new ItemStack((IItemProvider)ConsumeSetup.VIAL.get(), 1);
            CompoundNBT nbt = new CompoundNBT();
            for (Metal mt : Metal.values()) {
                nbt.func_74757_a(mt.getName(), metals[mt.getIndex()]);
            }
            nbt.func_74768_a("CustomModelData", 1);
            this.item_result.func_77982_d(nbt);
            return true;
        }
        return false;
    }

    public ItemStack assemble(CraftingInventory inv) {
        return this.item_result.func_77946_l();
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.item_result;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ConsumeSetup.VIAL_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends SpecialRecipeSerializer<VialItemRecipe> {
        public Serializer() {
            super(VialItemRecipe::new);
        }
    }
}

