/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.materials.world;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.modules.materials.MaterialsConfig;
import com.legobmw99.allomancy.modules.materials.MaterialsSetup;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.RegistryObject;

public class OreGenerator {
    private static final ArrayList<OreData> ores = new ArrayList();

    public static void registerFeatures() {
        Registry registry = WorldGenRegistries.field_243653_e;
        for (OreData ore : ores) {
            ResourceLocation block = ore.ore_block.getRegistryName();
            Allomancy.LOGGER.info("Registering configured feature generation for block " + block.toString());
            ore.feature = OreGenerator.featureFromData(ore);
            Registry.func_218322_a((Registry)registry, (ResourceLocation)block, ore.feature);
        }
    }

    public static void registerGeneration(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generation = event.getGeneration();
        for (OreData ore : ores) {
            if (!ore.config_enabled) continue;
            generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ore.feature);
        }
    }

    private static ConfiguredFeature<?, ?> featureFromData(OreData ore) {
        return (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ore.ore_block.func_176223_P(), ore.vein_size)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(ore.min_height, ore.min_height, ore.max_height))).func_242728_a()).func_242731_b(ore.ores_per_chunk);
    }

    static {
        ores.add(new OreData(MaterialsConfig.aluminum_max_y, MaterialsConfig.aluminum_min_y, MaterialsConfig.aluminum_size, MaterialsConfig.aluminum_density, MaterialsSetup.ALUMINUM_ORE, MaterialsConfig.generate_aluminum));
        ores.add(new OreData(MaterialsConfig.cadmium_max_y, MaterialsConfig.cadmium_min_y, MaterialsConfig.cadmium_size, MaterialsConfig.cadmium_density, MaterialsSetup.CADMIUM_ORE, MaterialsConfig.generate_cadmium));
        ores.add(new OreData(MaterialsConfig.chromium_max_y, MaterialsConfig.chromium_min_y, MaterialsConfig.chromium_size, MaterialsConfig.cadmium_density, MaterialsSetup.CHROMIUM_ORE, MaterialsConfig.generate_chromium));
        ores.add(new OreData(MaterialsConfig.copper_max_y, MaterialsConfig.copper_min_y, MaterialsConfig.copper_size, MaterialsConfig.copper_density, MaterialsSetup.COPPER_ORE, MaterialsConfig.generate_copper));
        ores.add(new OreData(MaterialsConfig.lead_max_y, MaterialsConfig.lead_min_y, MaterialsConfig.lead_size, MaterialsConfig.lead_density, MaterialsSetup.LEAD_ORE, MaterialsConfig.generate_lead));
        ores.add(new OreData(MaterialsConfig.silver_max_y, MaterialsConfig.silver_min_y, MaterialsConfig.silver_size, MaterialsConfig.silver_density, MaterialsSetup.SILVER_ORE, MaterialsConfig.generate_silver));
        ores.add(new OreData(MaterialsConfig.tin_max_y, MaterialsConfig.tin_min_y, MaterialsConfig.tin_size, MaterialsConfig.tin_density, MaterialsSetup.TIN_ORE, MaterialsConfig.generate_tin));
        ores.add(new OreData(MaterialsConfig.zinc_max_y, MaterialsConfig.zinc_min_y, MaterialsConfig.zinc_size, MaterialsConfig.zinc_density, MaterialsSetup.ZINC_ORE, MaterialsConfig.generate_zinc));
    }

    private static class OreData {
        public final int max_height;
        public final int min_height;
        public final int vein_size;
        public final int ores_per_chunk;
        public final Block ore_block;
        public final boolean config_enabled;
        public ConfiguredFeature<?, ?> feature = null;

        protected OreData(ForgeConfigSpec.IntValue max_height, ForgeConfigSpec.IntValue min_height, ForgeConfigSpec.IntValue vein_size, ForgeConfigSpec.IntValue ores_per_chunk, RegistryObject<Block> ore_block, ForgeConfigSpec.BooleanValue config_enabled) {
            this.max_height = (Integer)max_height.get();
            this.min_height = (Integer)min_height.get();
            this.vein_size = (Integer)vein_size.get();
            this.ores_per_chunk = (Integer)ores_per_chunk.get();
            this.ore_block = (Block)ore_block.get();
            this.config_enabled = (Boolean)config_enabled.get();
        }
    }
}

