/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.item.KolossBladeItem;
import com.legobmw99.allomancy.modules.materials.MaterialsSetup;
import com.legobmw99.allomancy.modules.powers.PowerUtils;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import com.legobmw99.allomancy.modules.powers.data.AllomancerDataProvider;
import com.legobmw99.allomancy.modules.powers.network.UpdateEnhancedPacket;
import com.legobmw99.allomancy.network.Network;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonEventHandler {
    @SubscribeEvent
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            AllomancerDataProvider provider = new AllomancerDataProvider();
            event.addCapability(AllomancerCapability.IDENTIFIER, (ICapabilityProvider)provider);
            event.addListener(provider::invalidate);
        }
    }

    @SubscribeEvent
    public static void onJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                if (((Boolean)PowersConfig.random_mistings.get()).booleanValue() && data.isUninvested()) {
                    byte randomMisting = (byte)(Math.random() * (double)Metal.values().length);
                    data.addPower(Metal.getMetal(randomMisting));
                    ItemStack flakes = new ItemStack((IItemProvider)MaterialsSetup.FLAKES.get(randomMisting).get());
                    if (!player.field_71071_by.func_70441_a(flakes)) {
                        ItemEntity entity = new ItemEntity(player.func_130014_f_(), player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b(), player.func_213303_ch().func_82616_c(), flakes);
                        player.func_130014_f_().func_217376_c((Entity)entity);
                    }
                }
            });
            Network.sync(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.getPlayer().field_70170_p.func_201670_d()) {
            PlayerEntity player = event.getPlayer();
            player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> event.getOriginal().getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(oldData -> {
                data.setDeathLoc(oldData.getDeathLoc(), oldData.getDeathDim());
                if (!oldData.isUninvested()) {
                    for (Metal mt : Metal.values()) {
                        if (!oldData.hasPower(mt)) continue;
                        data.addPower(mt);
                    }
                }
                if (player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || !event.isWasDeath()) {
                    for (Metal mt : Metal.values()) {
                        data.setAmount(mt, oldData.getAmount(mt));
                    }
                }
            }));
            Network.sync(player);
        }
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getPlayer().func_130014_f_().func_201670_d()) {
            Network.sync(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getPlayer().func_130014_f_().func_201670_d()) {
            Network.sync(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        if (!event.getTarget().field_70170_p.field_72995_K && event.getTarget() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getTarget();
            Network.sync((PlayerEntity)player);
        }
    }

    @SubscribeEvent
    public static void onSetSpawn(PlayerSetSpawnEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                data.setSpawnLoc(event.getNewSpawn(), (RegistryKey<World>)event.getSpawnWorld());
                Network.sync(data, player);
            });
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                data.setDeathLoc(new BlockPos(player.func_213303_ch()), (RegistryKey<World>)player.field_70170_p.func_234923_W_());
                Network.sync(data, (PlayerEntity)player);
            });
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof ServerPlayerEntity) {
            ServerPlayerEntity source = (ServerPlayerEntity)event.getSource().func_76346_g();
            source.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                if (data.isBurning(Metal.PEWTER)) {
                    if (data.isEnhanced()) {
                        if (source.func_184614_ca().func_77973_b() instanceof KolossBladeItem) {
                            event.setAmount(550.0f);
                            PowerUtils.wipePlayer((PlayerEntity)source);
                        } else {
                            event.setAmount(event.getAmount() * 3.0f);
                        }
                    } else {
                        event.setAmount(event.getAmount() + 2.0f);
                    }
                }
                if (data.isBurning(Metal.CHROMIUM) && event.getEntityLiving() instanceof PlayerEntity) {
                    PowerUtils.wipePlayer((PlayerEntity)event.getEntityLiving());
                }
            });
        }
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            event.getEntityLiving().getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                if (data.isBurning(Metal.PEWTER)) {
                    if (data.isEnhanced()) {
                        Allomancy.LOGGER.debug("Canceling Damage");
                        event.setAmount(0.0f);
                        event.setCanceled(true);
                    } else {
                        Allomancy.LOGGER.debug("Reducing Damage");
                        event.setAmount(event.getAmount() - 2.0f);
                        data.setDamageStored(data.getDamageStored() + 1);
                        Network.sync(data, (PlayerEntity)((ServerPlayerEntity)event.getEntityLiving()));
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            World world = event.world;
            List list = world.func_217369_A();
            for (int enti = list.size() - 1; enti >= 0; --enti) {
                PlayerEntity curPlayer = (PlayerEntity)list.get(enti);
                curPlayer.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                    if (!data.isUninvested()) {
                        RegistryKey<World> deathDim;
                        BlockPos positive;
                        BlockPos negative;
                        if (data.isBurning(Metal.ALUMINUM)) {
                            PowerUtils.wipePlayer(curPlayer);
                        }
                        if (data.isBurning(Metal.DURALUMIN) && !data.isEnhanced()) {
                            data.setEnhanced(2);
                            Network.sync(new UpdateEnhancedPacket(2, curPlayer.func_145782_y()), curPlayer);
                        } else if (!data.isBurning(Metal.DURALUMIN) && data.isEnhanced()) {
                            data.decEnhanced();
                            if (!data.isEnhanced()) {
                                Network.sync(new UpdateEnhancedPacket(false, curPlayer.func_145782_y()), curPlayer);
                                data.drainMetals((Metal[])Arrays.stream(Metal.values()).filter(data::isBurning).toArray(Metal[]::new));
                            }
                        }
                        if (curPlayer instanceof ServerPlayerEntity) {
                            data.tickBurning((ServerPlayerEntity)curPlayer);
                        }
                        if (data.isEnhanced() && data.isBurning(Metal.CHROMIUM) && event.world instanceof ServerWorld) {
                            int max = 20;
                            negative = new BlockPos(curPlayer.func_213303_ch()).func_177982_a(-max, -max, -max);
                            positive = new BlockPos(curPlayer.func_213303_ch()).func_177982_a(max, max, max);
                            event.world.func_217357_a(PlayerEntity.class, new AxisAlignedBB(negative, positive)).forEach(otherPlayer -> otherPlayer.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(otherData -> otherData.drainMetals(Metal.values())));
                        }
                        if (data.isEnhanced() && data.isBurning(Metal.ELECTRUM) && data.getAmount(Metal.ELECTRUM) >= 9) {
                            BlockPos spawnLoc;
                            RegistryKey spawnDim = data.getSpawnDim();
                            if (spawnDim != null) {
                                spawnLoc = data.getSpawnLoc();
                            } else {
                                spawnDim = World.field_234918_g_;
                                spawnLoc = new BlockPos(curPlayer.field_70170_p.func_72912_H().func_76079_c(), curPlayer.field_70170_p.func_72912_H().func_76075_d(), curPlayer.field_70170_p.func_72912_H().func_76074_e());
                            }
                            PowerUtils.teleport(curPlayer, event.world, (RegistryKey<World>)spawnDim, spawnLoc);
                            if (data.isBurning(Metal.DURALUMIN)) {
                                data.drainMetals(Metal.DURALUMIN);
                            }
                            data.drainMetals(Metal.ELECTRUM);
                        } else if (data.isEnhanced() && data.isBurning(Metal.GOLD) && data.getAmount(Metal.GOLD) >= 9 && (deathDim = data.getDeathDim()) != null) {
                            PowerUtils.teleport(curPlayer, event.world, deathDim, data.getDeathLoc());
                            if (data.isBurning(Metal.DURALUMIN)) {
                                data.drainMetals(Metal.DURALUMIN);
                            }
                            data.drainMetals(Metal.GOLD);
                        }
                        if (data.isBurning(Metal.BENDALLOY) && !data.isBurning(Metal.CADMIUM)) {
                            curPlayer.func_195064_c(new EffectInstance(Effects.field_76422_e, 10, 3, true, false));
                            curPlayer.func_70636_d();
                            curPlayer.func_70636_d();
                            if (event.world instanceof ServerWorld) {
                                int max = data.isEnhanced() ? 10 : 5;
                                negative = new BlockPos(curPlayer.func_213303_ch()).func_177982_a(-max, -max, -max);
                                positive = new BlockPos(curPlayer.func_213303_ch()).func_177982_a(max, max, max);
                                event.world.func_217357_a(LivingEntity.class, new AxisAlignedBB(negative, positive)).forEach(entity -> {
                                    entity.func_70636_d();
                                    entity.func_70636_d();
                                });
                                BlockPos.func_218281_b((BlockPos)negative, (BlockPos)positive).forEach(bp -> {
                                    BlockState block = event.world.func_180495_p(bp);
                                    TileEntity te = event.world.func_175625_s(bp);
                                    for (int i = 0; i < max * 4 / (te == null ? 10 : 1); ++i) {
                                        if (te instanceof ITickableTileEntity) {
                                            ((ITickableTileEntity)te).func_73660_a();
                                            continue;
                                        }
                                        if (!block.func_204519_t()) continue;
                                        block.func_227034_b_((ServerWorld)event.world, bp, event.world.field_73012_v);
                                    }
                                });
                            }
                        }
                        if (data.isBurning(Metal.CADMIUM) && !data.isBurning(Metal.BENDALLOY)) {
                            int max = data.isEnhanced() ? 20 : 10;
                            negative = new BlockPos(curPlayer.func_213303_ch()).func_177982_a(-max, -max, -max);
                            positive = new BlockPos(curPlayer.func_213303_ch()).func_177982_a(max, max, max);
                            int slowness_amplifier = data.isEnhanced() ? 255 : 2;
                            event.world.func_217357_a(LivingEntity.class, new AxisAlignedBB(negative, positive)).forEach(entity -> {
                                entity.func_195064_c(new EffectInstance(Effects.field_204839_B, 10, 0, true, false));
                                if (entity != curPlayer) {
                                    entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 10, slowness_amplifier, true, false));
                                }
                            });
                        }
                        if (data.isBurning(Metal.TIN)) {
                            curPlayer.func_195064_c(new EffectInstance(Effects.field_76439_r, Short.MAX_VALUE, 5, true, false));
                            if (data.isEnhanced()) {
                                curPlayer.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 150, true, false));
                                if (event.world.field_73012_v.nextInt(50) == 0) {
                                    curPlayer.func_195064_c(new EffectInstance(Effects.field_76431_k, 100, 0, true, false));
                                }
                            } else if (curPlayer.func_70644_a(Effects.field_76440_q)) {
                                curPlayer.func_195063_d(Effects.field_76440_q);
                            }
                        }
                        if (!data.isBurning(Metal.TIN) && curPlayer.func_70660_b(Effects.field_76439_r) != null && curPlayer.func_70660_b(Effects.field_76439_r).func_76458_c() == 5) {
                            curPlayer.func_195063_d(Effects.field_76439_r);
                        }
                        if (data.isBurning(Metal.PEWTER)) {
                            curPlayer.func_195064_c(new EffectInstance(Effects.field_76430_j, 10, 1, true, false));
                            curPlayer.func_195064_c(new EffectInstance(Effects.field_76424_c, 10, 0, true, false));
                            curPlayer.func_195064_c(new EffectInstance(Effects.field_76422_e, 10, 1, true, false));
                            if (data.getDamageStored() > 0 && event.world.field_73012_v.nextInt(200) == 0) {
                                data.setDamageStored(data.getDamageStored() - 1);
                            }
                        }
                        if (!data.isBurning(Metal.PEWTER) && data.getDamageStored() > 0) {
                            data.setDamageStored(data.getDamageStored() - 1);
                            curPlayer.func_70097_a(DamageSource.field_76376_m, 2.0f);
                        }
                        if (data.isEnhanced() && data.isBurning(Metal.COPPER)) {
                            curPlayer.func_195064_c(new EffectInstance(Effects.field_76441_p, 20, 50, true, false));
                        }
                    }
                });
            }
        }
    }
}

