/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.entity.ProjectileNuggetEntity;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import com.legobmw99.allomancy.modules.powers.entity.ai.AIAttackOnCollideExtended;
import com.legobmw99.allomancy.modules.powers.entity.ai.AIEvilAttack;
import com.legobmw99.allomancy.network.Network;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.CreeperSwellGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class PowerUtils {
    public static final byte PUSH = 1;
    public static final byte PULL = -1;
    private static final Predicate<Goal> isAggroGoal = goal -> goal instanceof CreeperSwellGoal || goal instanceof AIAttackOnCollideExtended || goal instanceof MeleeAttackGoal || goal instanceof TargetGoal || goal instanceof PanicGoal || goal.getClass().getName().contains("Fireball") || goal.getClass().getName().contains("Attack") || goal.getClass().getName().contains("Anger");
    private static final Pattern ACTIVE_METAL_REGEX = Pattern.compile(".*(iron|steel|tin_|pewter|zinc|brass|copper|bronze|duralumin|chromium|nicrosil|gold|electrum|cadmium|bendalloy|lead_|silver|platinum|nickle).*");

    public static boolean doesResourceContainsMetal(ResourceLocation input) {
        return ACTIVE_METAL_REGEX.matcher(input.func_110623_a()).matches();
    }

    public static boolean isBlockStateMetal(BlockState state) {
        return PowerUtils.isBlockMetal(state.func_177230_c());
    }

    public static boolean isBlockMetal(Block block) {
        return PowerUtils.isOnWhitelist(block.getRegistryName().toString());
    }

    public static boolean isItemMetal(ItemStack item) {
        return PowerUtils.isOnWhitelist(item.func_77973_b().getRegistryName().toString());
    }

    private static boolean isOnWhitelist(String s) {
        return PowersConfig.whitelist.contains(s);
    }

    public static boolean isEntityMetal(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof ItemEntity) {
            return PowerUtils.isItemMetal(((ItemEntity)entity).func_92059_d());
        }
        if (entity instanceof ItemFrameEntity) {
            return PowerUtils.isItemMetal(((ItemFrameEntity)entity).func_82335_i());
        }
        if (entity instanceof FallingBlockEntity) {
            return PowerUtils.isBlockStateMetal(((FallingBlockEntity)entity).func_195054_l());
        }
        if (entity instanceof ProjectileNuggetEntity) {
            return true;
        }
        if (entity instanceof AbstractMinecartEntity) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity ent = (LivingEntity)entity;
            if (ent instanceof IronGolemEntity) {
                return true;
            }
            if (PowerUtils.isItemMetal(ent.func_184586_b(Hand.MAIN_HAND)) || PowerUtils.isItemMetal(ent.func_184586_b(Hand.OFF_HAND))) {
                return true;
            }
            for (ItemStack itemStack : ent.func_184193_aE()) {
                if (!PowerUtils.isItemMetal(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static void wipePlayer(PlayerEntity player) {
        player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
            data.drainMetals(Metal.values());
            player.func_195061_cb();
            if (player instanceof ServerPlayerEntity) {
                Network.sync(data, player);
            }
        });
    }

    public static void move(double directionScalar, Entity toMove, BlockPos block) {
        if (toMove.func_184218_aH()) {
            toMove = toMove.func_184187_bx();
        }
        Vector3d motion = toMove.func_213303_ch().func_178788_d(Vector3d.func_237489_a_((Vector3i)block)).func_72432_b().func_186678_a(directionScalar * 1.1);
        Vector3d mod = PowerUtils.clamp(PowerUtils.cutoff(motion.func_178787_e(toMove.func_213322_ci()), 0.1), PowerUtils.abs(motion).func_216371_e(), PowerUtils.abs(motion));
        toMove.func_213317_d(mod);
        toMove.field_70133_I = true;
        if (toMove instanceof ServerPlayerEntity) {
            toMove.field_70143_R = 0.0f;
        }
    }

    private static Vector3d clamp(Vector3d value, Vector3d min, Vector3d max) {
        return new Vector3d(MathHelper.func_151237_a((double)value.field_72450_a, (double)min.field_72450_a, (double)max.field_72450_a), MathHelper.func_151237_a((double)value.field_72448_b, (double)min.field_72448_b, (double)max.field_72448_b), MathHelper.func_151237_a((double)value.field_72449_c, (double)min.field_72449_c, (double)max.field_72449_c));
    }

    private static Vector3d abs(Vector3d vec) {
        return new Vector3d(Math.abs(vec.field_72450_a), Math.abs(vec.field_72448_b), Math.abs(vec.field_72449_c));
    }

    private static Vector3d cutoff(Vector3d value, double e) {
        Vector3d mag = PowerUtils.abs(value);
        return new Vector3d(mag.field_72450_a < e ? 0.0 : value.field_72450_a, mag.field_72448_b < e ? 0.0 : value.field_72448_b, mag.field_72449_c < e ? 0.0 : value.field_72449_c);
    }

    public static void teleport(PlayerEntity player, World world, RegistryKey<World> dimension, final BlockPos pos) {
        if (!world.field_72995_K && player != null) {
            if (player.func_184218_aH()) {
                player.func_184210_p();
            }
            if (player.field_70170_p.func_234923_W_() != dimension) {
                player = (PlayerEntity)player.changeDimension(world.func_73046_m().func_71218_a(dimension), new ITeleporter(){

                    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                        Entity repositionedEntity = repositionEntity.apply(false);
                        repositionedEntity.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                        return repositionedEntity;
                    }
                });
            }
            player.func_223102_j((double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p());
            player.field_70143_R = 0.0f;
        }
    }

    public static void riotEntity(CreatureEntity target, PlayerEntity allomancer, boolean enhanced) {
        try {
            if (!enhanced) {
                target.field_70715_bh.func_220886_b(Goal.Flag.TARGET);
                target.func_70624_b((LivingEntity)allomancer);
                target.func_70604_c((LivingEntity)allomancer);
                target.field_70715_bh.func_75776_a(1, (Goal)new AIAttackOnCollideExtended(target, 1.0, false));
                target.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)target, PlayerEntity.class, false));
                target.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)target, target.getClass(), false));
                target.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)target));
                target.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal(target, new Class[0]).func_220794_a(new Class[0]));
                if (target.func_110148_a(Attributes.field_233823_f_) != null && !(target instanceof GuardianEntity)) {
                    target.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal(target, 1.2, true));
                }
                target.func_213395_q(true);
                if (target instanceof CreeperEntity) {
                    target.field_70714_bg.func_75776_a(1, (Goal)new CreeperSwellGoal((CreeperEntity)target));
                }
                if (target instanceof RabbitEntity) {
                    target.field_70714_bg.func_75776_a(1, (Goal)new AIEvilAttack((RabbitEntity)target));
                }
                if (target instanceof AbstractSkeletonEntity) {
                    target.field_70714_bg.func_75776_a(1, (Goal)new RangedBowAttackGoal((MonsterEntity)((AbstractSkeletonEntity)target), 1.0, 20, 15.0f));
                }
                if (target instanceof IllusionerEntity) {
                    target.field_70714_bg.func_75776_a(1, (Goal)new RangedBowAttackGoal((MonsterEntity)((IllusionerEntity)target), 0.5, 20, 15.0f));
                }
                if (target instanceof PillagerEntity) {
                    target.field_70714_bg.func_75776_a(2, (Goal)new RangedCrossbowAttackGoal((MonsterEntity)((PillagerEntity)target), 1.0, 8.0f));
                }
            } else {
                target.field_70170_p.func_217398_a((Entity)target, target.func_213303_ch().func_82615_a(), target.func_213303_ch().func_82617_b(), target.func_213303_ch().func_82616_c(), 1.2f, false, Explosion.Mode.BREAK);
                target.func_70106_y();
            }
        }
        catch (Exception e) {
            Allomancy.LOGGER.error("Failed to riot entity " + target + "! Please report this error!", (Throwable)e);
        }
    }

    public static void sootheEntity(CreatureEntity target, PlayerEntity allomancer, boolean enhanced) {
        try {
            if (!enhanced) {
                if (target.func_175446_cd()) {
                    target.func_94061_f(false);
                }
                target.field_70714_bg.func_220888_c().filter(isAggroGoal).forEach(PrioritizedGoal::func_75251_c);
                target.field_70715_bh.func_220888_c().filter(isAggroGoal).forEach(PrioritizedGoal::func_75251_c);
                target.field_70714_bg.func_75774_a();
                target.field_70715_bh.func_75774_a();
                target.func_70624_b(null);
                target.func_70604_c(null);
                target.field_70715_bh.func_220880_a(Goal.Flag.TARGET);
                target.func_213395_q(false);
                target.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)target, PlayerEntity.class, 6.0f));
                if (target instanceof TameableEntity && Math.random() < 0.3) {
                    ((TameableEntity)target).func_193101_c(allomancer);
                }
                if (target instanceof AbstractHorseEntity && Math.random() < 0.3) {
                    ((AbstractHorseEntity)target).func_110263_g(allomancer);
                }
                if (target instanceof SheepEntity) {
                    target.field_70714_bg.func_75776_a(1, (Goal)new EatGrassGoal((MobEntity)target));
                }
                if (target instanceof VillagerEntity) {
                    ((VillagerEntity)target).func_213739_a(IReputationType.field_221033_e, (Entity)allomancer);
                }
                if (target instanceof WanderingTraderEntity) {
                    target.field_70714_bg.func_75776_a(1, (Goal)new TradeWithPlayerGoal((AbstractVillagerEntity)target));
                }
            } else {
                target.func_94061_f(true);
            }
        }
        catch (Exception e) {
            Allomancy.LOGGER.error("Failed to soothe entity " + target + "! Please report this error!", (Throwable)e);
        }
    }
}

