/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.consumables.ConsumeSetup;
import com.legobmw99.allomancy.modules.powers.PowerUtils;
import com.legobmw99.allomancy.util.AllomancyConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PowersConfig {
    public static final Set<String> whitelist = new HashSet<String>();
    public static ForgeConfigSpec.IntValue max_metal_detection;
    public static ForgeConfigSpec.BooleanValue animate_selection;
    public static ForgeConfigSpec.BooleanValue enable_more_keybinds;
    public static ForgeConfigSpec.BooleanValue enable_overlay;
    public static ForgeConfigSpec.EnumValue<SCREEN_LOC> overlay_position;
    public static ForgeConfigSpec.BooleanValue random_mistings;
    public static ForgeConfigSpec.BooleanValue generate_whitelist;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> cfg_whitelist;
    private static HashSet<String> defaultList;

    public static void init(ForgeConfigSpec.Builder common_builder, ForgeConfigSpec.Builder client_builder) {
        common_builder.comment("Settings for the gameplay elements of the mod").push("gameplay");
        random_mistings = common_builder.comment("Spawn players as a random Misting").define("random_mistings", true);
        generate_whitelist = common_builder.comment("Regenerate the metal whitelist").define("regenerate_whitelist", true);
        cfg_whitelist = common_builder.comment("List of registry names of items and blocks that are counted as 'metal").defineList("whitelist", new ArrayList(), o -> o instanceof String);
        common_builder.pop();
        client_builder.push("graphics");
        max_metal_detection = client_builder.comment("Maximum iron/steelsight distance. Can have a HUGE impact on performance").defineInRange("max_metal_distance", 15, 3, 30);
        animate_selection = client_builder.comment("Animate the selection wheel").define("animate_selection", true);
        enable_overlay = client_builder.comment("Enable the screen overlay").define("overlay_enabled", true);
        overlay_position = client_builder.comment("Screen Overlay Position").defineEnum("overlay_position", (Enum)SCREEN_LOC.TOP_LEFT);
        client_builder.pop();
        client_builder.push("controls");
        enable_more_keybinds = client_builder.comment("Register extra keys, one for each metal, which toggle that metal specifically").define("advanced_keybinds", false);
        client_builder.pop();
    }

    public static void refresh(ModConfig.ModConfigEvent e) {
        ModConfig cfg = e.getConfig();
        if (cfg.getSpec() == AllomancyConfig.COMMON_CONFIG) {
            PowersConfig.refresh_whitelist();
        }
    }

    private static void refresh_whitelist() {
        whitelist.clear();
        whitelist.addAll((Collection)cfg_whitelist.get());
    }

    public static void load_whitelist(ModConfig.Loading e) {
        ModConfig cfg = e.getConfig();
        if (cfg.getSpec() == AllomancyConfig.COMMON_CONFIG) {
            if (((Boolean)generate_whitelist.get()).booleanValue()) {
                ArrayList<String> list = new ArrayList<String>(PowersConfig.default_whitelist());
                list.sort(String::compareTo);
                cfg_whitelist.set(list);
                generate_whitelist.set((Object)false);
            }
            PowersConfig.refresh_whitelist();
        }
    }

    private static Set<String> default_whitelist() {
        defaultList = new HashSet();
        PowersConfig.add(Items.field_151029_X);
        PowersConfig.add(Items.field_151133_ar);
        PowersConfig.add(Items.field_151129_at);
        PowersConfig.add(Items.field_151117_aB);
        PowersConfig.add(Items.field_203797_aN);
        PowersConfig.add(Items.field_203795_aL);
        PowersConfig.add(Items.field_203796_aM);
        PowersConfig.add(Items.field_204272_aO);
        PowersConfig.add(Items.field_151131_as);
        PowersConfig.add(Items.field_222089_ms);
        PowersConfig.add(Items.field_151111_aL);
        PowersConfig.add(Items.field_151020_U);
        PowersConfig.add(Items.field_151022_W);
        PowersConfig.add(Items.field_151143_au);
        PowersConfig.add(Items.field_151108_aI);
        PowersConfig.add(Items.field_151140_bW);
        PowersConfig.add(Items.field_151109_aJ);
        PowersConfig.add(Items.field_151142_bV);
        PowersConfig.add(Items.field_151023_V);
        PowersConfig.add(Items.field_151113_aN);
        PowersConfig.add(Items.field_151097_aZ);
        PowersConfig.add(Items.field_185159_cQ);
        PowersConfig.add(Items.field_234759_km_);
        PowersConfig.add(Items.field_234760_kn_);
        PowersConfig.add(Items.field_234763_ls_);
        PowersConfig.add(Items.field_234764_lt_);
        PowersConfig.add(Items.field_234765_lu_);
        PowersConfig.add(Items.field_234766_lv_);
        PowersConfig.add(Items.field_234758_kU_);
        PowersConfig.add(Items.field_234756_kK_);
        PowersConfig.add(Items.field_234755_kJ_);
        PowersConfig.add(Items.field_234754_kI_);
        PowersConfig.add(Items.field_234757_kL_);
        PowersConfig.add(Items.field_222114_py);
        PowersConfig.add(Blocks.field_150467_bQ);
        PowersConfig.add(Blocks.field_196717_eY);
        PowersConfig.add(Blocks.field_196718_eZ);
        PowersConfig.add(Blocks.field_150383_bp);
        PowersConfig.add(Blocks.field_222429_lR);
        PowersConfig.add(Blocks.field_222430_lS);
        PowersConfig.add(Blocks.field_235341_dI_);
        PowersConfig.add(Blocks.field_150438_bZ);
        PowersConfig.add(Blocks.field_150332_K);
        PowersConfig.add(Blocks.field_196603_bb);
        PowersConfig.add(Blocks.field_150320_F);
        PowersConfig.add(Blocks.field_222424_lM);
        PowersConfig.add(Blocks.field_222431_lT);
        PowersConfig.add(Blocks.field_150331_J);
        PowersConfig.add(Blocks.field_150445_bS);
        PowersConfig.add(Blocks.field_150443_bT);
        PowersConfig.add(Blocks.field_150448_aq);
        PowersConfig.add(Blocks.field_150408_cc);
        PowersConfig.add(Blocks.field_150319_E);
        PowersConfig.add(Blocks.field_196552_aC);
        PowersConfig.add(Blocks.field_222432_lU);
        PowersConfig.add(Blocks.field_150447_bR);
        PowersConfig.add(Blocks.field_150479_bC);
        PowersConfig.add(Blocks.field_235366_md_);
        PowersConfig.add(Blocks.field_235397_ng_);
        PowersConfig.add(Blocks.field_235398_nh_);
        PowersConfig.add(Blocks.field_235405_no_);
        PowersConfig.add(Blocks.field_235387_nA_);
        PowersConfig.add((ForgeRegistryEntry)ConsumeSetup.VIAL.get());
        PowersConfig.add((ForgeRegistryEntry)ConsumeSetup.LERASIUM_NUGGET.get());
        PowersConfig.add((ForgeRegistryEntry)ConsumeSetup.ALLOMANTIC_GRINDER.get());
        PowersConfig.add((ForgeRegistryEntry)CombatSetup.COIN_BAG.get());
        ForgeRegistries.ITEMS.getValues().stream().map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).filter(PowerUtils::doesResourceContainsMetal).forEach(PowersConfig::add);
        ForgeRegistries.BLOCKS.getValues().stream().map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).filter(PowerUtils::doesResourceContainsMetal).forEach(PowersConfig::add);
        return defaultList;
    }

    private static void add(String s) {
        Allomancy.LOGGER.info("Adding " + s + " to the default whitelist!");
        defaultList.add(s);
    }

    private static void add(ResourceLocation r) {
        PowersConfig.add(r.toString());
    }

    private static void add(ForgeRegistryEntry<?> registryEntry) {
        PowersConfig.add(registryEntry.getRegistryName());
    }

    public static enum SCREEN_LOC {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;

    }
}

