/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.client;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.combat.CombatSetup;
import com.legobmw99.allomancy.modules.powers.PowerUtils;
import com.legobmw99.allomancy.modules.powers.PowersConfig;
import com.legobmw99.allomancy.modules.powers.client.PowersClientSetup;
import com.legobmw99.allomancy.modules.powers.client.gui.MetalOverlay;
import com.legobmw99.allomancy.modules.powers.client.gui.MetalSelectScreen;
import com.legobmw99.allomancy.modules.powers.client.particle.SoundParticleData;
import com.legobmw99.allomancy.modules.powers.client.util.ClientUtils;
import com.legobmw99.allomancy.modules.powers.client.util.MetalBlockBlob;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import com.legobmw99.allomancy.modules.powers.network.ChangeEmotionPacket;
import com.legobmw99.allomancy.modules.powers.network.TryPushPullBlock;
import com.legobmw99.allomancy.modules.powers.network.TryPushPullEntity;
import com.legobmw99.allomancy.modules.powers.network.UpdateEnhancedPacket;
import com.legobmw99.allomancy.network.Network;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    private final Set<Entity> metal_entities = new HashSet<Entity>();
    private final Set<MetalBlockBlob> metal_blobs = new HashSet<MetalBlockBlob>();
    private final Set<PlayerEntity> nearby_allomancers = new HashSet<PlayerEntity>();
    private int tickOffset = 0;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !this.mc.func_147113_T() && this.mc.field_71439_g != null && this.mc.field_71439_g.func_70089_S()) {
            ClientPlayerEntity player = this.mc.field_71439_g;
            player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(arg_0 -> this.lambda$onClientTick$6((PlayerEntity)player, arg_0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (event.getAction() == 1) {
            this.acceptInput();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseInputEvent event) {
        if (event.getAction() == 1) {
            this.acceptInput();
        }
    }

    private void acceptInput() {
        boolean extras;
        boolean bl = extras = PowersClientSetup.enable_more_keybinds && Arrays.stream(PowersClientSetup.powers).anyMatch(k -> k.func_151470_d());
        if (PowersClientSetup.burn.func_151470_d() || extras) {
            ClientPlayerEntity player = this.mc.field_71439_g;
            if (this.mc.field_71462_r == null) {
                if (player == null || !this.mc.func_195544_aj()) {
                    return;
                }
                player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
                    if (extras) {
                        for (int i = 0; i < PowersClientSetup.powers.length; ++i) {
                            if (!PowersClientSetup.powers[i].func_151470_d()) continue;
                            ClientUtils.toggleBurn(Metal.getMetal(i), data);
                        }
                    } else {
                        int num_powers = data.getPowerCount();
                        if (num_powers == 0) {
                            return;
                        }
                        if (num_powers == 1) {
                            ClientUtils.toggleBurn(data.getPowers()[0], data);
                        } else {
                            this.mc.func_147108_a((Screen)new MetalSelectScreen());
                        }
                    }
                });
            }
        }
        if (PowersClientSetup.hud.func_151470_d()) {
            PowersConfig.enable_overlay.set((Object)((Boolean)PowersConfig.enable_overlay.get() == false ? 1 : 0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent event) {
        if (!((Boolean)PowersConfig.enable_overlay.get()).booleanValue() && !(this.mc.field_71462_r instanceof MetalSelectScreen)) {
            return;
        }
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (!this.mc.func_195544_aj() || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        if (this.mc.field_71462_r != null && !(this.mc.field_71462_r instanceof ChatScreen) && !(this.mc.field_71462_r instanceof MetalSelectScreen)) {
            return;
        }
        MetalOverlay.drawMetalOverlay(event.getMatrixStack());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        if (player == null || !player.func_70089_S() || this.mc.field_71474_y.func_243230_g().func_243193_b()) {
            return;
        }
        player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(arg_0 -> this.lambda$onRenderWorldLast$9(event, (PlayerEntity)player, arg_0));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onSound(PlaySoundEvent event) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        ISound sound = event.getSound();
        if (player == null || sound == null || !player.func_70089_S()) {
            return;
        }
        player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(arg_0 -> this.lambda$onSound$10((PlayerEntity)player, sound, event, arg_0));
    }

    private /* synthetic */ void lambda$onSound$10(PlayerEntity player, ISound sound, PlaySoundEvent event, IAllomancerData data) {
        if (data.isBurning(Metal.TIN)) {
            double magnitude = Math.sqrt(player.func_213303_ch().func_186679_c(sound.func_147649_g(), sound.func_147654_h(), sound.func_147651_i()));
            if (magnitude > 25.0 || magnitude < 3.0) {
                return;
            }
            Vector3d vec = player.func_213303_ch();
            double posX = vec.func_82615_a();
            double posY = vec.func_82617_b();
            double posZ = vec.func_82616_c();
            String soundName = sound.func_147650_b().toString();
            if (soundName.contains("entity") || soundName.contains("step")) {
                double motionX = (posX - (event.getSound().func_147649_g() + 0.5)) * -0.7 / magnitude;
                double motionY = (posY - (event.getSound().func_147654_h() + 0.2)) * -0.7 / magnitude;
                double motionZ = (posZ - (event.getSound().func_147651_i() + 0.5)) * -0.7 / magnitude;
                this.mc.field_71452_i.func_199280_a((IParticleData)new SoundParticleData(sound.func_184365_d()), posX + Math.sin(Math.toRadians(player.func_70079_am())) * -0.7, posY + 0.2, posZ + Math.cos(Math.toRadians(player.func_70079_am())) * 0.7, motionX, motionY, motionZ);
            }
        }
    }

    private /* synthetic */ void lambda$onRenderWorldLast$9(RenderWorldLastEvent event, PlayerEntity player, IAllomancerData data) {
        RegistryKey<World> deathDim;
        if (data.isUninvested()) {
            return;
        }
        MatrixStack stack = event.getMatrixStack();
        stack.func_227860_a_();
        Vector3d view = this.mc.field_175622_Z.func_174824_e(event.getPartialTicks());
        stack.func_227861_a_(-view.field_72450_a, -view.field_72448_b, -view.field_72449_c);
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)stack.func_227866_c_().func_227870_a_());
        RenderSystem.disableTexture();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.polygonMode((int)1032, (int)6913);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableBlend();
        double dist = 1.0;
        double yaw = (double)(this.mc.field_71439_g.field_70177_z + 90.0f) * Math.PI / 180.0;
        double pitch = (double)(this.mc.field_71439_g.field_70125_A + 90.0f) * Math.PI / 180.0;
        Vector3d playervec = view.func_72441_c((double)(MathHelper.func_76126_a((float)((float)pitch)) * MathHelper.func_76134_b((float)((float)yaw))) * dist, (double)MathHelper.func_76134_b((float)((float)pitch)) * dist - 0.35, (double)(MathHelper.func_76126_a((float)((float)pitch)) * MathHelper.func_76126_a((float)((float)yaw))) * dist);
        if (data.isBurning(Metal.IRON) || data.isBurning(Metal.STEEL)) {
            for (Entity entity : this.metal_entities) {
                ClientUtils.drawMetalLine(playervec, entity.func_213303_ch(), 1.5f, 0.0f, 0.6f, 1.0f);
            }
            for (MetalBlockBlob mb : this.metal_blobs) {
                ClientUtils.drawMetalLine(playervec, mb.getCenter(), MathHelper.func_76131_a((float)(0.3f + (float)mb.size() * 0.4f), (float)0.5f, (float)7.5f), 0.0f, 0.6f, 1.0f);
            }
        }
        if (data.isBurning(Metal.BRONZE) && (data.isEnhanced() || !data.isBurning(Metal.COPPER))) {
            for (PlayerEntity playerEntity : this.nearby_allomancers) {
                ClientUtils.drawMetalLine(playervec, playerEntity.func_213303_ch(), 5.0f, 0.7f, 0.15f, 0.15f);
            }
        }
        if (data.isBurning(Metal.GOLD) && (deathDim = data.getDeathDim()) != null && player.field_70170_p.func_234923_W_() == deathDim) {
            ClientUtils.drawMetalLine(playervec, Vector3d.func_237489_a_((Vector3i)data.getDeathLoc()), 3.0f, 0.9f, 0.85f, 0.0f);
        }
        if (data.isBurning(Metal.ELECTRUM)) {
            RegistryKey<World> spawnDim = data.getSpawnDim();
            if (spawnDim == null && player.field_70170_p.func_234923_W_() == World.field_234918_g_) {
                BlockPos spawnLoc = new BlockPos(player.field_70170_p.func_72912_H().func_76079_c(), player.field_70170_p.func_72912_H().func_76075_d(), player.field_70170_p.func_72912_H().func_76074_e());
                ClientUtils.drawMetalLine(playervec, Vector3d.func_237489_a_((Vector3i)spawnLoc), 3.0f, 0.7f, 0.8f, 0.2f);
            } else if (spawnDim != null && player.field_70170_p.func_234923_W_() == spawnDim) {
                ClientUtils.drawMetalLine(playervec, Vector3d.func_237489_a_((Vector3i)data.getSpawnLoc()), 3.0f, 0.7f, 0.8f, 0.2f);
            }
        }
        RenderSystem.polygonMode((int)1032, (int)6914);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableTexture();
        RenderSystem.popMatrix();
        stack.func_227865_b_();
    }

    private /* synthetic */ void lambda$onClientTick$6(PlayerEntity player, IAllomancerData data) {
        block15: {
            Entity entity2;
            BlockPos bp2;
            RayTraceResult trace;
            int dist_modifier;
            if (data.isUninvested()) break block15;
            int force_multiplier = data.isEnhanced() ? 4 : 1;
            int n = dist_modifier = data.isEnhanced() ? 2 : 1;
            if (this.mc.field_71474_y.field_74312_F.func_151470_d()) {
                trace = ClientUtils.getMouseOverExtended(20.0f * (float)dist_modifier);
                if (data.isBurning(Metal.IRON) && trace != null) {
                    if (trace.func_216346_c() == RayTraceResult.Type.ENTITY && PowerUtils.isEntityMetal(((EntityRayTraceResult)trace).func_216348_a())) {
                        Network.sendToServer(new TryPushPullEntity(((EntityRayTraceResult)trace).func_216348_a().func_145782_y(), -1 * force_multiplier));
                    }
                    if (trace.func_216346_c() == RayTraceResult.Type.BLOCK && (PowerUtils.isBlockStateMetal(this.mc.field_71441_e.func_180495_p(bp2 = ((BlockRayTraceResult)trace).func_216350_a())) || player.func_184614_ca().func_77973_b() == CombatSetup.COIN_BAG.get() && player.func_213453_ef())) {
                        Network.sendToServer(new TryPushPullBlock(bp2, -1 * force_multiplier));
                    }
                }
                if (data.isBurning(Metal.ZINC) && trace != null && trace.func_216346_c() == RayTraceResult.Type.ENTITY && (entity2 = ((EntityRayTraceResult)trace).func_216348_a()) instanceof CreatureEntity) {
                    Network.sendToServer(new ChangeEmotionPacket(entity2.func_145782_y(), true));
                }
            }
            if (this.mc.field_71474_y.field_74313_G.func_151470_d()) {
                trace = ClientUtils.getMouseOverExtended(20.0f * (float)dist_modifier);
                if (data.isBurning(Metal.STEEL) && trace != null) {
                    if (trace.func_216346_c() == RayTraceResult.Type.ENTITY && PowerUtils.isEntityMetal(((EntityRayTraceResult)trace).func_216348_a())) {
                        Network.sendToServer(new TryPushPullEntity(((EntityRayTraceResult)trace).func_216348_a().func_145782_y(), 1 * force_multiplier));
                    }
                    if (trace.func_216346_c() == RayTraceResult.Type.BLOCK && (PowerUtils.isBlockStateMetal(this.mc.field_71441_e.func_180495_p(bp2 = ((BlockRayTraceResult)trace).func_216350_a())) || player.func_184614_ca().func_77973_b() == CombatSetup.COIN_BAG.get() && player.func_213453_ef())) {
                        Network.sendToServer(new TryPushPullBlock(bp2, 1 * force_multiplier));
                    }
                }
                if (data.isBurning(Metal.BRASS) && trace != null && trace.func_216346_c() == RayTraceResult.Type.ENTITY && (entity2 = ((EntityRayTraceResult)trace).func_216348_a()) instanceof CreatureEntity) {
                    Network.sendToServer(new ChangeEmotionPacket(entity2.func_145782_y(), false));
                }
                if (data.isBurning(Metal.NICROSIL) && trace != null && trace.func_216346_c() == RayTraceResult.Type.ENTITY && (entity2 = ((EntityRayTraceResult)trace).func_216348_a()) instanceof PlayerEntity) {
                    Network.sendToServer(new UpdateEnhancedPacket(true, entity2.func_145782_y()));
                }
            }
            this.tickOffset = (this.tickOffset + 1) % 2;
            if (this.tickOffset == 0) {
                this.metal_blobs.clear();
                this.metal_entities.clear();
                if (data.isBurning(Metal.IRON) || data.isBurning(Metal.STEEL)) {
                    int max = (Integer)PowersConfig.max_metal_detection.get();
                    BlockPos negative = player.func_233580_cy_().func_177982_a(-max, -max, -max);
                    BlockPos positive = player.func_233580_cy_().func_177982_a(max, max, max);
                    this.metal_entities.addAll(player.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(negative, positive), e -> PowerUtils.isEntityMetal(e) && !e.equals((Object)player)));
                    Stream blocks = BlockPos.func_218281_b((BlockPos)negative, (BlockPos)positive);
                    blocks.filter(bp -> PowerUtils.isBlockStateMetal(player.field_70170_p.func_180495_p(bp))).forEach(bp -> {
                        Set matches = this.metal_blobs.stream().filter(mbl -> mbl.isMatch((BlockPos)bp)).collect(Collectors.toSet());
                        switch (matches.size()) {
                            case 0: {
                                this.metal_blobs.add(new MetalBlockBlob((BlockPos)bp));
                                break;
                            }
                            case 1: {
                                ((MetalBlockBlob)matches.stream().findAny().get()).add((BlockPos)bp);
                                break;
                            }
                            default: {
                                this.metal_blobs.removeAll(matches);
                                MetalBlockBlob mbb = matches.stream().reduce(null, MetalBlockBlob::merge);
                                mbb.add((BlockPos)bp);
                                this.metal_blobs.add(mbb);
                            }
                        }
                    });
                }
                this.nearby_allomancers.clear();
                if (data.isBurning(Metal.BRONZE) && (data.isEnhanced() || !data.isBurning(Metal.COPPER))) {
                    PlayerEntity otherPlayer;
                    boolean cont;
                    BlockPos negative = player.func_233580_cy_().func_177982_a(-30, -30, -30);
                    BlockPos positive = player.func_233580_cy_().func_177982_a(30, 30, 30);
                    List nearby_players = player.field_70170_p.func_175647_a(PlayerEntity.class, new AxisAlignedBB(negative, positive), entity -> entity != null && entity != player);
                    Iterator iterator = nearby_players.iterator();
                    while (iterator.hasNext() && (cont = (otherPlayer = (PlayerEntity)iterator.next()).getCapability(AllomancerCapability.PLAYER_CAP).map(otherData -> {
                        if (otherData.isBurning(Metal.COPPER) && (!data.isEnhanced() || otherData.isEnhanced())) {
                            return false;
                        }
                        for (Metal mt : Metal.values()) {
                            if (!otherData.isBurning(mt)) continue;
                            this.nearby_allomancers.add(otherPlayer);
                            break;
                        }
                        return true;
                    }).orElse(true).booleanValue())) {
                    }
                }
            }
        }
    }
}

