/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.command;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.command.AllomancyPowerType;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import com.legobmw99.allomancy.network.Network;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.NonNullConsumer;

public class AllomancyPowerCommand {
    private static final DynamicCommandExceptionType ERROR_CANT_ADD = new DynamicCommandExceptionType(s -> new TranslationTextComponent("commands.allomancy.err_add", new Object[]{s}));
    private static final DynamicCommandExceptionType ERROR_CANT_REMOVE = new DynamicCommandExceptionType(s -> new TranslationTextComponent("commands.allomancy.err_remove", new Object[]{s}));

    private static Predicate<CommandSource> permissions(int level) {
        return player -> player.func_197034_c(level);
    }

    private static Collection<ServerPlayerEntity> sender(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        return Collections.singleton(((CommandSource)ctx.getSource()).func_197035_h());
    }

    private static Collection<ServerPlayerEntity> target(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        return EntityArgument.func_197090_e(ctx, (String)"target");
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.func_197057_a((String)"allomancy").requires(AllomancyPowerCommand.permissions(0));
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").requires(AllomancyPowerCommand.permissions(0))).executes(ctx -> AllomancyPowerCommand.handleMultiPlayer((CommandContext<CommandSource>)ctx, AllomancyPowerCommand.sender((CommandContext<CommandSource>)ctx), AllomancyPowerCommand::getPowers))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> AllomancyPowerCommand.handleMultiPlayer((CommandContext<CommandSource>)ctx, AllomancyPowerCommand.target((CommandContext<CommandSource>)ctx), AllomancyPowerCommand::getPowers))));
        root.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires(AllomancyPowerCommand.permissions(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)AllomancyPowerType.INSTANCE).executes(ctx -> AllomancyPowerCommand.handleMultiPlayer((CommandContext<CommandSource>)ctx, AllomancyPowerCommand.sender((CommandContext<CommandSource>)ctx), AllomancyPowerCommand::addPower))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> AllomancyPowerCommand.handleMultiPlayer((CommandContext<CommandSource>)ctx, AllomancyPowerCommand.target((CommandContext<CommandSource>)ctx), AllomancyPowerCommand::addPower)))));
        root.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").requires(AllomancyPowerCommand.permissions(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)AllomancyPowerType.INSTANCE).executes(ctx -> AllomancyPowerCommand.handleMultiPlayer((CommandContext<CommandSource>)ctx, AllomancyPowerCommand.sender((CommandContext<CommandSource>)ctx), AllomancyPowerCommand::removePower))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> AllomancyPowerCommand.handleMultiPlayer((CommandContext<CommandSource>)ctx, AllomancyPowerCommand.target((CommandContext<CommandSource>)ctx), AllomancyPowerCommand::removePower)))));
        LiteralCommandNode command = dispatcher.register(root);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ap").requires(AllomancyPowerCommand.permissions(0))).redirect((CommandNode)command));
    }

    private static int handleMultiPlayer(CommandContext<CommandSource> ctx, Collection<ServerPlayerEntity> players, CheckedBiCon<CommandContext<CommandSource>, ServerPlayerEntity> toApply) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayerEntity p : players) {
            toApply.accept(ctx, p);
            ++i;
        }
        return i;
    }

    private static void getPowers(CommandContext<CommandSource> ctx, ServerPlayerEntity player) {
        StringBuilder powers = new StringBuilder();
        player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(data -> {
            if (data.isMistborn()) {
                powers.append("all");
            } else if (data.isUninvested()) {
                powers.append("none");
            } else {
                for (Metal mt : Metal.values()) {
                    if (!data.hasPower(mt)) continue;
                    if (powers.length() == 0) {
                        powers.append(mt.getName());
                        continue;
                    }
                    powers.append(", ").append(mt.getName());
                }
            }
        });
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.allomancy.getpowers", new Object[]{player.func_145748_c_(), powers.toString()}), true);
    }

    private static void addPower(CommandContext<CommandSource> ctx, ServerPlayerEntity player) throws CommandSyntaxException {
        AllomancyPowerCommand.handlePowerChange(ctx, player, (NonNullConsumer<IAllomancerData>)((NonNullConsumer)IAllomancerData::setMistborn), data -> mt -> !data.hasPower((Metal)((Object)((Object)mt))), mt -> data -> data.addPower((Metal)((Object)mt)), arg_0 -> ((DynamicCommandExceptionType)ERROR_CANT_ADD).create(arg_0), "commands.allomancy.addpower");
    }

    private static void removePower(CommandContext<CommandSource> ctx, ServerPlayerEntity player) throws CommandSyntaxException {
        AllomancyPowerCommand.handlePowerChange(ctx, player, (NonNullConsumer<IAllomancerData>)((NonNullConsumer)IAllomancerData::setUninvested), data -> data::hasPower, mt -> data -> data.revokePower((Metal)((Object)mt)), arg_0 -> ((DynamicCommandExceptionType)ERROR_CANT_REMOVE).create(arg_0), "commands.allomancy.removepower");
    }

    private static void handlePowerChange(CommandContext<CommandSource> ctx, ServerPlayerEntity player, NonNullConsumer<IAllomancerData> all, Function<IAllomancerData, Predicate<Metal>> filterFunction, Function<Metal, NonNullConsumer<IAllomancerData>> single, Function<String, CommandSyntaxException> exception, String success) throws CommandSyntaxException {
        String type = (String)ctx.getArgument("type", String.class);
        if (type.equalsIgnoreCase("all")) {
            player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(all);
        } else {
            Predicate<Metal> filter = player.getCapability(AllomancerCapability.PLAYER_CAP).map(filterFunction::apply).orElse(m -> false);
            if (type.equalsIgnoreCase("random")) {
                List<Metal> metalList = Arrays.asList(Metal.values());
                Collections.shuffle(metalList);
                Metal mt = metalList.stream().filter(filter).findFirst().orElseThrow(() -> (CommandSyntaxException)exception.apply(type));
                player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(single.apply(mt));
            } else {
                Metal mt = Metal.valueOf(type.toUpperCase());
                if (filter.test(mt)) {
                    player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(single.apply(mt));
                } else {
                    throw exception.apply(type);
                }
            }
        }
        Network.sync((PlayerEntity)player);
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(success, new Object[]{player.func_145748_c_(), type}), true);
    }

    @FunctionalInterface
    private static interface CheckedBiCon<T, U> {
        public void accept(T var1, U var2) throws CommandSyntaxException;
    }
}

