/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.data;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.modules.powers.data.DefaultAllomancerData;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class AllomancerCapability {
    @CapabilityInject(value=IAllomancerData.class)
    public static final Capability<IAllomancerData> PLAYER_CAP = null;
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("allomancy", "allomancy_data");

    public static void register() {
        CapabilityManager.INSTANCE.register(IAllomancerData.class, (Capability.IStorage)new Storage(), DefaultAllomancerData::new);
    }

    public static class Storage
    implements Capability.IStorage<IAllomancerData> {
        public INBT writeNBT(Capability<IAllomancerData> capability, IAllomancerData data, Direction side) {
            BlockPos spawn_pos;
            CompoundNBT allomancy_data = new CompoundNBT();
            CompoundNBT abilities = new CompoundNBT();
            for (Metal mt : Metal.values()) {
                abilities.func_74757_a(mt.getName(), data.hasPower(mt));
            }
            allomancy_data.func_218657_a("abilities", (INBT)abilities);
            CompoundNBT metal_storage = new CompoundNBT();
            for (Metal mt : Metal.values()) {
                metal_storage.func_74768_a(mt.getName(), data.getAmount(mt));
            }
            allomancy_data.func_218657_a("metal_storage", (INBT)metal_storage);
            CompoundNBT metal_burning = new CompoundNBT();
            for (Metal mt : Metal.values()) {
                metal_burning.func_74757_a(mt.getName(), data.isBurning(mt));
            }
            allomancy_data.func_218657_a("metal_burning", (INBT)metal_burning);
            CompoundNBT position = new CompoundNBT();
            BlockPos death_pos = data.getDeathLoc();
            if (death_pos != null) {
                position.func_74778_a("death_dimension", data.getDeathDim().func_240901_a_().toString());
                position.func_74768_a("death_x", death_pos.func_177958_n());
                position.func_74768_a("death_y", death_pos.func_177956_o());
                position.func_74768_a("death_z", death_pos.func_177952_p());
            }
            if ((spawn_pos = data.getSpawnLoc()) != null) {
                position.func_74778_a("spawn_dimension", data.getSpawnDim().func_240901_a_().toString());
                position.func_74768_a("spawn_x", spawn_pos.func_177958_n());
                position.func_74768_a("spawn_y", spawn_pos.func_177956_o());
                position.func_74768_a("spawn_z", spawn_pos.func_177952_p());
            }
            allomancy_data.func_218657_a("position", (INBT)position);
            return allomancy_data;
        }

        public void readNBT(Capability<IAllomancerData> capability, IAllomancerData data, Direction side, INBT nbt) {
            CompoundNBT allomancy_data = (CompoundNBT)nbt;
            CompoundNBT abilities = (CompoundNBT)allomancy_data.func_74781_a("abilities");
            for (Metal mt : Metal.values()) {
                if (abilities.func_74767_n(mt.getName())) {
                    data.addPower(mt);
                    continue;
                }
                data.revokePower(mt);
            }
            CompoundNBT metal_storage = (CompoundNBT)allomancy_data.func_74781_a("metal_storage");
            for (Metal mt : Metal.values()) {
                data.setAmount(mt, metal_storage.func_74762_e(mt.getName()));
            }
            CompoundNBT metal_burning = (CompoundNBT)allomancy_data.func_74781_a("metal_burning");
            for (Metal mt : Metal.values()) {
                data.setBurning(mt, metal_burning.func_74767_n(mt.getName()));
            }
            CompoundNBT position = (CompoundNBT)allomancy_data.func_74781_a("position");
            if (position.func_74764_b("death_dimension")) {
                data.setDeathLoc(new BlockPos(position.func_74762_e("death_x"), position.func_74762_e("death_y"), position.func_74762_e("death_z")), position.func_74779_i("death_dimension"));
            }
            if (position.func_74764_b("spawn_dimension")) {
                data.setSpawnLoc(new BlockPos(position.func_74762_e("spawn_x"), position.func_74762_e("spawn_y"), position.func_74762_e("spawn_z")), position.func_74779_i("spawn_dimension"));
            }
        }
    }
}

