/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.data;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.api.enums.Metal;
import com.legobmw99.allomancy.network.Network;
import java.util.Arrays;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class DefaultAllomancerData
implements IAllomancerData {
    private static final int[] MAX_BURN_TIME = new int[]{1800, 1800, 3600, 600, 1800, 1800, 2400, 1600, 100, 20, 300, 40, 1000, 10000, 3600, 160};
    private final boolean[] allomantic_powers;
    private final int[] burn_time;
    private final int[] metal_amounts;
    private final boolean[] burning_metals;
    private int damage_stored;
    private String death_dimension;
    private BlockPos death_pos;
    private String spawn_dimension;
    private BlockPos spawn_pos;
    private int enhanced_time;

    public DefaultAllomancerData() {
        int powers = Metal.values().length;
        this.allomantic_powers = new boolean[powers];
        Arrays.fill(this.allomantic_powers, false);
        this.metal_amounts = new int[powers];
        Arrays.fill(this.metal_amounts, 0);
        this.burn_time = Arrays.copyOf(MAX_BURN_TIME, powers);
        this.burning_metals = new boolean[powers];
        Arrays.fill(this.burning_metals, false);
        this.enhanced_time = 0;
        this.damage_stored = 0;
        this.death_pos = null;
        this.spawn_pos = null;
    }

    @Override
    public void tickBurning(ServerPlayerEntity player) {
        boolean sync = false;
        for (Metal metal : Metal.values()) {
            if (!this.isBurning(metal)) continue;
            if (!this.hasPower(metal)) {
                this.setBurning(metal, false);
                sync = true;
                continue;
            }
            this.setBurnTime(metal, this.getBurnTime(metal) - 1);
            if (this.getBurnTime(metal) > 0) continue;
            if (this.getAmount(metal) <= 0) {
                this.setBurning(metal, false);
                sync = true;
            } else {
                this.setAmount(metal, this.getAmount(metal) - 1);
            }
            this.setBurnTime(metal, MAX_BURN_TIME[metal.getIndex()]);
        }
        if (sync) {
            Network.sync(this, (PlayerEntity)player);
        }
    }

    @Override
    public boolean hasPower(Metal metal) {
        return this.allomantic_powers[metal.getIndex()];
    }

    @Override
    public int getPowerCount() {
        int count = 0;
        for (boolean power : this.allomantic_powers) {
            if (!power) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Metal[] getPowers() {
        return (Metal[])Arrays.stream(Metal.values()).filter(this::hasPower).toArray(Metal[]::new);
    }

    @Override
    public boolean isMistborn() {
        for (boolean power : this.allomantic_powers) {
            if (power) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setMistborn() {
        Arrays.fill(this.allomantic_powers, true);
    }

    @Override
    public boolean isUninvested() {
        for (boolean power : this.allomantic_powers) {
            if (!power) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setUninvested() {
        Arrays.fill(this.allomantic_powers, false);
    }

    @Override
    public void addPower(Metal metal) {
        this.allomantic_powers[metal.getIndex()] = true;
    }

    @Override
    public void revokePower(Metal metal) {
        this.allomantic_powers[metal.getIndex()] = false;
    }

    @Override
    public boolean isBurning(Metal metal) {
        return this.burning_metals[metal.getIndex()];
    }

    @Override
    public void setBurning(Metal metal, boolean metalBurning) {
        this.burning_metals[metal.getIndex()] = metalBurning;
    }

    @Override
    public int getAmount(Metal metal) {
        return this.metal_amounts[metal.getIndex()];
    }

    @Override
    public void setAmount(Metal metal, int amt) {
        this.metal_amounts[metal.getIndex()] = amt;
    }

    @Override
    public void drainMetals(Metal ... metals) {
        for (Metal mt : metals) {
            this.metal_amounts[mt.getIndex()] = 0;
            this.burn_time[mt.getIndex()] = 1;
        }
    }

    @Override
    public int getDamageStored() {
        return this.damage_stored;
    }

    @Override
    public void setDamageStored(int damageStored) {
        this.damage_stored = damageStored;
    }

    @Override
    public void setDeathLoc(BlockPos pos, RegistryKey<World> dim) {
        if (dim != null) {
            this.setDeathLoc(pos, dim.func_240901_a_().toString());
        }
    }

    @Override
    public void setDeathLoc(BlockPos pos, String dim_name) {
        this.death_pos = pos;
        this.death_dimension = dim_name;
    }

    @Override
    public BlockPos getDeathLoc() {
        return this.death_pos;
    }

    @Override
    public RegistryKey<World> getDeathDim() {
        if (this.death_dimension == null) {
            return null;
        }
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(this.death_dimension));
    }

    @Override
    public void setSpawnLoc(BlockPos pos, RegistryKey<World> dim) {
        this.setSpawnLoc(pos, dim.func_240901_a_().toString());
    }

    @Override
    public void setSpawnLoc(BlockPos pos, String dim_name) {
        this.spawn_pos = pos;
        this.spawn_dimension = dim_name;
    }

    @Override
    public BlockPos getSpawnLoc() {
        return this.spawn_pos;
    }

    @Override
    public RegistryKey<World> getSpawnDim() {
        if (this.spawn_dimension == null) {
            return null;
        }
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(this.spawn_dimension));
    }

    protected int getBurnTime(Metal metal) {
        return this.burn_time[metal.getIndex()];
    }

    protected void setBurnTime(Metal metal, int burnTime) {
        this.burn_time[metal.getIndex()] = burnTime;
    }

    @Override
    public void decEnhanced() {
        if (this.isEnhanced()) {
            --this.enhanced_time;
        }
    }

    @Override
    public boolean isEnhanced() {
        return this.enhanced_time > 0;
    }

    @Override
    public void setEnhanced(int time) {
        this.enhanced_time = time;
    }
}

