/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.modules.powers.network;

import com.legobmw99.allomancy.api.data.IAllomancerData;
import com.legobmw99.allomancy.modules.powers.data.AllomancerCapability;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class AllomancerDataPacket {
    private final CompoundNBT nbt;
    private final UUID uuid;

    public AllomancerDataPacket(IAllomancerData data, PlayerEntity player) {
        this.uuid = player.func_110124_au();
        this.nbt = data != null && AllomancerCapability.PLAYER_CAP != null ? (CompoundNBT)AllomancerCapability.PLAYER_CAP.writeNBT((Object)data, null) : new CompoundNBT();
    }

    private AllomancerDataPacket(CompoundNBT nbt, UUID uuid) {
        this.nbt = nbt;
        this.uuid = uuid;
    }

    public static AllomancerDataPacket decode(PacketBuffer buf) {
        return new AllomancerDataPacket(buf.func_150793_b(), buf.func_179253_g());
    }

    public void encode(PacketBuffer buf) {
        buf.func_150786_a(this.nbt);
        buf.func_179252_a(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerEntity player = Minecraft.func_71410_x().field_71441_e.func_217371_b(this.uuid);
            if (player != null && AllomancerCapability.PLAYER_CAP != null) {
                player.getCapability(AllomancerCapability.PLAYER_CAP).ifPresent(cap -> AllomancerCapability.PLAYER_CAP.readNBT(cap, null, (INBT)this.nbt));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

