/*
 * Decompiled with CFR 0.152.
 */
package openlyfay.ancientgateways.maths;

import java.util.ArrayList;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class MasterList
extends class_18 {
    private static ArrayList<GatewayAddress> locations = new ArrayList();
    private static final String key = "ancientgateways_masterlist";

    public MasterList() {
        super(key);
    }

    public static MasterList get(class_1937 world) {
        class_3218 serverWorld = (class_3218)world;
        return (MasterList)serverWorld.method_17983().method_17924(MasterList::new, key);
    }

    private static GatewayAddress getElement(String addressName) {
        if (locations.isEmpty()) {
            return null;
        }
        for (GatewayAddress gatewayAddress : locations) {
            if (!gatewayAddress.getAddress().equals(addressName)) continue;
            return gatewayAddress;
        }
        return null;
    }

    public void addElement(String address, class_243 position, class_5321<class_1937> world) {
        if (MasterList.getElement(address) == null) {
            GatewayAddress gatewayAddress = new GatewayAddress(address, position, world);
            locations.add(gatewayAddress);
            this.method_80();
        }
    }

    public static boolean doesElementExist(String address) {
        return MasterList.getElement(address) != null;
    }

    public static class_243 getPosition(String address) {
        if (MasterList.getElement(address) != null) {
            return MasterList.getElement(address).getPosition();
        }
        return null;
    }

    public static class_5321<class_1937> getWorld(String address) {
        if (MasterList.getElement(address) != null) {
            return MasterList.getElement(address).getWorld();
        }
        return null;
    }

    public void removeElement(String address) {
        locations.remove(MasterList.getElement(address));
        this.method_80();
    }

    public void method_77(class_2487 tag) {
        class_2499 listTag = tag.method_10554("gateways", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 compoundTag = listTag.method_10602(i);
            locations.add(new GatewayAddress(compoundTag));
        }
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 listTag = new class_2499();
        for (GatewayAddress location : locations) {
            class_2487 compoundTag = new class_2487();
            location.toTag(compoundTag);
            listTag.add((Object)compoundTag);
        }
        if (!listTag.isEmpty()) {
            tag.method_10566("gateways", (class_2520)listTag);
        }
        return tag;
    }

    private class GatewayAddress {
        private final String address;
        private final class_243 position;
        private final class_5321<class_1937> world;

        public GatewayAddress(String newAddress, class_243 newPosition, class_5321<class_1937> newWorld) {
            this.address = newAddress;
            this.position = newPosition;
            this.world = newWorld;
        }

        public GatewayAddress(class_2487 tag) {
            this.address = tag.method_10558("address");
            this.position = new class_243(tag.method_10574("posX"), tag.method_10574("posY"), tag.method_10574("posZ"));
            this.world = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(tag.method_10558("world")));
        }

        public class_5321<class_1937> getWorld() {
            return this.world;
        }

        public String getAddress() {
            return this.address;
        }

        public class_243 getPosition() {
            return this.position;
        }

        public GatewayAddress fromTag(class_2487 tag) {
            return new GatewayAddress(tag);
        }

        public class_2487 toTag(class_2487 tag) {
            tag.method_10582("address", this.address);
            tag.method_10549("posX", this.position.field_1352);
            tag.method_10549("posY", this.position.field_1351);
            tag.method_10549("posZ", this.position.field_1350);
            tag.method_10582("world", this.world.method_29177().toString());
            return tag;
        }
    }
}

