/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.entity.projectile;

import cofh.archersparadox.init.APReferences;
import cofh.core.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class TrainingArrowEntity
extends AbstractArrowEntity {
    private static float baseDamage = 0.0f;
    private static final int DISTANCE_FACTOR = 4;
    private static final int MAX_DISTANCE = 10;
    private static final int DURATION = 200;
    private static final int MIN_DURATION = 40;
    private Vector3d origin;

    public TrainingArrowEntity(EntityType<? extends TrainingArrowEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
        this.field_70255_ao = baseDamage;
    }

    public TrainingArrowEntity(World worldIn, LivingEntity shooter) {
        super(APReferences.TRAINING_ARROW_ENTITY, shooter, worldIn);
        this.field_70255_ao = baseDamage;
        this.origin = shooter.func_213303_ch();
    }

    public TrainingArrowEntity(World worldIn, double x, double y, double z) {
        super(APReferences.TRAINING_ARROW_ENTITY, x, y, z, worldIn);
        this.field_70255_ao = baseDamage;
        this.origin = new Vector3d(x, y, z);
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)APReferences.TRAINING_ARROW_ITEM);
    }

    protected void func_70227_a(RayTraceResult raytraceResultIn) {
        PlayerEntity shooter;
        if (raytraceResultIn.func_216346_c() == RayTraceResult.Type.BLOCK && this.func_234616_v_() instanceof PlayerEntity && !Utils.isFakePlayer((Entity)this.func_234616_v_()) && (shooter = (PlayerEntity)this.func_234616_v_()).func_70644_a(APReferences.TRAINING_STREAK)) {
            EffectInstance effect = shooter.func_70660_b(APReferences.TRAINING_STREAK);
            shooter.func_70688_c(effect);
            shooter.func_184596_c(APReferences.TRAINING_STREAK);
            Vector3d originVec = this.origin == null ? shooter.func_213303_ch() : this.origin;
            double distance = originVec.func_72438_d(this.func_213303_ch());
            int distanceBonus = (int)(4.0 * distance);
            shooter.func_195064_c(new EffectInstance(APReferences.TRAINING_MISS, Math.max(40, 200 - distanceBonus), 0, false, false));
            shooter.field_70170_p.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_187561_bM, shooter.func_184176_by(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        }
        super.func_70227_a(raytraceResultIn);
    }

    protected void func_213868_a(EntityRayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.func_216348_a();
        if (entity instanceof LivingEntity) {
            PlayerEntity shooter;
            LivingEntity target = (LivingEntity)entity;
            if (this.func_234616_v_() instanceof PlayerEntity && !Utils.isFakePlayer((Entity)this.func_234616_v_()) && (shooter = (PlayerEntity)this.func_234616_v_()) != target && !shooter.func_70644_a(APReferences.TRAINING_MISS)) {
                Vector3d originVec;
                double distance;
                int trainingCount = 0;
                if (shooter.func_70644_a(APReferences.TRAINING_STREAK)) {
                    trainingCount = shooter.func_70660_b(APReferences.TRAINING_STREAK).func_76458_c() + 1;
                }
                if ((distance = (originVec = this.origin == null ? shooter.func_213303_ch() : this.origin).func_72438_d(this.func_213303_ch())) >= (double)Math.min(10, trainingCount)) {
                    int distanceBonus = (int)(4.0 * distance);
                    shooter.func_195064_c(new EffectInstance(APReferences.TRAINING_STREAK, 200 + distanceBonus, trainingCount, false, false));
                    shooter.func_184185_a(SoundEvents.field_193808_ex, 1.0f, Math.min(0.6f + 0.05f * (float)trainingCount, 1.1f));
                    shooter.field_70170_p.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_193808_ex, shooter.func_184176_by(), 1.0f, Math.min(0.6f + 0.05f * (float)trainingCount, 1.1f));
                }
            }
        }
        if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
            this.func_70099_a(this.func_184550_j(), 0.1f);
        }
        this.func_70106_y();
        this.func_184185_a(SoundEvents.field_187751_eD, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    public void func_70015_d(int seconds) {
    }

    public void func_70240_a(int knockbackStrengthIn) {
    }

    public void func_213872_b(byte level) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

