/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import com.teammetallurgy.atum.api.AtumAPI;
import com.teammetallurgy.atum.blocks.stone.khnumite.KhnumiteFaceBlock;
import com.teammetallurgy.atum.client.ClientHandler;
import com.teammetallurgy.atum.commands.AtumWeather;
import com.teammetallurgy.atum.init.AtumStructures;
import com.teammetallurgy.atum.integration.IntegrationHandler;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.misc.AtumItemGroup;
import com.teammetallurgy.atum.misc.AtumRegistry;
import com.teammetallurgy.atum.network.NetworkHandler;
import com.teammetallurgy.atum.world.SandstormHandler;
import com.teammetallurgy.atum.world.biome.AtumBiomeProvider;
import com.teammetallurgy.atum.world.gen.AtumChunkGenerator;
import net.minecraft.block.WoodType;
import net.minecraft.command.CommandSource;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="atum")
public class Atum {
    public static final String MOD_ID = "atum";
    public static final Logger LOG = LogManager.getLogger((String)StringUtils.capitalize((String)"atum"));
    public static final ItemGroup GROUP = new AtumItemGroup();
    public static final RegistryKey<World> ATUM = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("atum", "atum"));
    public static final Codec<AtumBiomeProvider> ATUM_LAYERD = (Codec)Registry.func_218322_a((Registry)Registry.field_239689_aA_, (ResourceLocation)new ResourceLocation("atum", "atum_layered"), AtumBiomeProvider.CODEC);
    public static final Codec<AtumChunkGenerator> ATUM_NOISE = (Codec)Registry.func_218322_a((Registry)Registry.field_239690_aB_, (ResourceLocation)new ResourceLocation("atum", "noise"), AtumChunkGenerator.CODEC);
    public static final WoodType PALM = WoodType.create((String)"atum_palm");
    public static final WoodType DEADWOOD = WoodType.create((String)"atum_deadwood");

    public Atum() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setupCommon);
        modBus.addListener(this::setupClient);
        modBus.addListener(this::interModComms);
        MinecraftForge.EVENT_BUS.addListener(this::onCommandRegistering);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, AtumConfig.spec);
        IntegrationHandler.INSTANCE.addSupport();
        AtumAPI.Tags.init();
        AtumRegistry.registerDeferredRegistries(modBus);
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        IntegrationHandler.INSTANCE.init();
        if (((Boolean)AtumConfig.SANDSTORM.sandstormEnabled.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.register((Object)SandstormHandler.INSTANCE);
        }
        MinecraftForge.EVENT_BUS.register(AtumStructures.PYRAMID_STRUCTURE);
        KhnumiteFaceBlock.addDispenserSupport();
        NetworkHandler.initialize();
        IntegrationHandler.INSTANCE.setup();
    }

    private void setupClient(FMLClientSetupEvent event) {
        ClientHandler.init();
        IntegrationHandler.INSTANCE.clientSide();
    }

    @SubscribeEvent
    public void onCommandRegistering(RegisterCommandsEvent event) {
        AtumWeather.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private void interModComms(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.NECKLACE.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.RING.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BRACELET.getMessageBuilder().build());
    }
}

