/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.api.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.teammetallurgy.atum.api.recipe.AbstractAtumRecipe;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class RotationRecipe<C extends IInventory>
extends AbstractAtumRecipe<C> {
    protected final int rotations;

    public RotationRecipe(IRecipeType<?> recipeType, ResourceLocation id, Ingredient input, @Nonnull ItemStack output, int rotations) {
        super(recipeType, id, input, output);
        this.rotations = rotations;
    }

    public int getRotations() {
        return this.rotations;
    }

    public static class Serializer<C extends RotationRecipe<? extends IInventory>>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<C> {
        private final IFactory<C> factory;
        private final boolean inputCanHaveCount;

        public Serializer(IFactory<C> factory, boolean inputCanHaveCount) {
            this.factory = factory;
            this.inputCanHaveCount = inputCanHaveCount;
        }

        @Nonnull
        public C read(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            ItemStack output;
            Ingredient input;
            JsonObject inputObject = JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            if (inputObject.has("tag")) {
                ResourceLocation tagLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)inputObject, (String)"tag"));
                ITag tag = ItemTags.func_199903_a().func_199910_a(tagLocation);
                if (tag != null && !tag.func_230236_b_().isEmpty()) {
                    Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)inputObject);
                    if (this.inputCanHaveCount && inputObject.has("count")) {
                        ArrayList<ItemStack> ingredientStacks = new ArrayList<ItemStack>();
                        for (ItemStack stack : ingredient.func_193365_a()) {
                            ingredientStacks.add(new ItemStack((IItemProvider)stack.func_77973_b(), JSONUtils.func_151208_a((JsonObject)inputObject, (String)"count", (int)1)));
                        }
                        input = Ingredient.func_193369_a((ItemStack[])ingredientStacks.toArray(new ItemStack[0]));
                    } else {
                        input = ingredient;
                    }
                } else {
                    input = Ingredient.field_193370_a;
                }
            } else if (!this.inputCanHaveCount) {
                input = CraftingHelper.getIngredient((JsonElement)inputObject);
            } else {
                ItemStack stack = CraftingHelper.getItemStack((JsonObject)inputObject, (boolean)true);
                input = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
            }
            if (!json.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (json.get("result").isJsonObject()) {
                output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            } else {
                String result = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
                ResourceLocation resultID = new ResourceLocation(result);
                output = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(resultID));
            }
            int rotations = JSONUtils.func_151208_a((JsonObject)json, (String)"rotations", (int)0);
            return this.factory.create(id, input, output, rotations);
        }

        public C read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack stack = buffer.func_150791_c();
            int rotations = buffer.readInt();
            return this.factory.create(id, ingredient, stack, rotations);
        }

        public void write(@Nonnull PacketBuffer buffer, C recipe) {
            ((RotationRecipe)recipe).input.func_199564_a(buffer);
            buffer.func_150788_a(((RotationRecipe)recipe).output);
            buffer.writeInt(((RotationRecipe)recipe).rotations);
        }

        public static interface IFactory<T extends RotationRecipe<? extends IInventory>> {
            public T create(ResourceLocation var1, Ingredient var2, @Nonnull ItemStack var3, int var4);
        }
    }
}

