/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.api.recipe.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.teammetallurgy.atum.api.recipe.AbstractAtumRecipe;
import com.teammetallurgy.atum.api.recipe.IAtumRecipeType;
import com.teammetallurgy.atum.blocks.machines.tileentity.KilnTileEntity;
import com.teammetallurgy.atum.init.AtumRecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class KilnRecipe
extends AbstractAtumRecipe<KilnTileEntity> {
    protected final float experience;
    protected final int cookTime;

    public KilnRecipe(@Nonnull ItemStack input, @Nonnull ItemStack output, float experience, int cookTime) {
        this(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), output, experience, cookTime);
    }

    public KilnRecipe(Tag<Item> input, @Nonnull ItemStack output, float experience, int cookTime) {
        this(Ingredient.func_199805_a(input), output, experience, cookTime);
    }

    public KilnRecipe(Ingredient input, @Nonnull ItemStack output, float experience, int cookTime) {
        this(new ResourceLocation("atum", "kiln"), input, output, experience, cookTime);
    }

    public KilnRecipe(ResourceLocation id, Ingredient input, @Nonnull ItemStack output, float experience, int cookTime) {
        super(IAtumRecipeType.KILN, id, input, output);
        this.experience = experience;
        this.cookTime = cookTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return AtumRecipeSerializers.KILN;
    }

    public static class Serializer<T extends KilnRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final IFactory<T> factory;
        private final int cookTime;

        public Serializer(IFactory<T> factory, int cookTime) {
            this.factory = factory;
            this.cookTime = cookTime;
        }

        @Nonnull
        public T read(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            ItemStack itemstack;
            JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
            if (!json.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (json.get("result").isJsonObject()) {
                itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            } else {
                String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                itemstack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(resourcelocation));
            }
            float f = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
            int i = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)this.cookTime);
            return this.factory.create(id, ingredient, itemstack, f, i);
        }

        public T read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack output = buffer.func_150791_c();
            float experience = buffer.readFloat();
            int cookTime = buffer.func_150792_a();
            return this.factory.create(id, input, output, experience, cookTime);
        }

        public void write(@Nonnull PacketBuffer buffer, T recipe) {
            ((KilnRecipe)recipe).input.func_199564_a(buffer);
            buffer.func_150788_a(((KilnRecipe)recipe).output);
            buffer.writeFloat(((KilnRecipe)recipe).experience);
            buffer.func_150787_b(((KilnRecipe)recipe).cookTime);
        }

        public static interface IFactory<T extends KilnRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, @Nonnull ItemStack var3, float var4, int var5);
        }
    }
}

