/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks;

import com.google.common.cache.LoadingCache;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.api.AtumAPI;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.teleporter.TeleporterAtum;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.ITeleporter;

public class PortalBlock
extends BreakableBlock {
    private static final VoxelShape PORTAL_AABB = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.875, (double)1.0);

    public PortalBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151567_E, (MaterialColor)MaterialColor.field_193562_N).func_200943_b(-1.0f).func_200947_a(SoundType.field_185853_f).func_226896_b_().func_235838_a_(state -> 10).func_200944_c());
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return PORTAL_AABB;
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader reader, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_225541_a_(@Nonnull BlockState state, @Nonnull Fluid fluid) {
        return false;
    }

    public boolean trySpawnPortal(World world, BlockPos pos) {
        Size size = new Size((IWorld)world, pos);
        if (size.isValid()) {
            size.placePortalBlocks();
            world.func_184133_a(null, pos, SoundEvents.field_193782_bq, SoundCategory.BLOCKS, 0.7f, 1.0f);
            return true;
        }
        Size size1 = new Size((IWorld)world, pos);
        if (size1.isValid()) {
            size1.placePortalBlocks();
            world.func_184133_a(null, pos, SoundEvents.field_193782_bq, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighborPos, boolean isMoving) {
        Size size = new Size((IWorld)world, pos);
        if ((neighborBlock == this || size.isSandBlock(neighborBlock.func_176223_P())) && !size.isValid()) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void func_196262_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (world instanceof ServerWorld) {
            PortalBlock.changeDimension((ServerWorld)world, entity, new TeleporterAtum());
        }
    }

    public static void changeDimension(ServerWorld serverWorld, Entity entity, ITeleporter teleporter) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU() && entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            RegistryKey<World> key = serverWorld.func_234923_W_() == Atum.ATUM ? World.field_234918_g_ : Atum.ATUM;
            ServerWorld destWorld = serverWorld.func_73046_m().func_71218_a(key);
            if (destWorld == null) {
                return;
            }
            if (player.field_242273_aw <= 0) {
                player.field_70170_p.func_217381_Z().func_76320_a("portal");
                player.changeDimension(destWorld, teleporter);
                player.field_242273_aw = 300;
                player.field_70170_p.func_217381_Z().func_76319_b();
            }
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ItemStack.field_190927_a;
    }

    public static BlockPattern.PatternHelper createPatternHelper(IWorld world, BlockPos pos) {
        Size size = new Size(world, pos);
        LoadingCache cache = BlockPattern.func_181627_a((IWorldReader)world, (boolean)true);
        if (!size.isValid()) {
            size = new Size(world, pos);
        }
        if (!size.isValid()) {
            return new BlockPattern.PatternHelper(pos, Direction.NORTH, Direction.SOUTH, cache, 1, 1, 1);
        }
        return new BlockPattern.PatternHelper(pos, Direction.NORTH, Direction.EAST, cache, size.width, 4, size.length);
    }

    public static class Size {
        private static final int MAX_SIZE = 9;
        private static final int MIN_SIZE = 3;
        private final IWorld world;
        private boolean valid = false;
        private BlockPos nw;
        private BlockPos se;
        private int width;
        private int length;

        public Size(IWorld world, BlockPos pos) {
            int y;
            this.world = world;
            int east = this.getDistanceUntilEdge(pos, Direction.EAST);
            int west = this.getDistanceUntilEdge(pos, Direction.WEST);
            int north = this.getDistanceUntilEdge(pos, Direction.NORTH);
            int south = this.getDistanceUntilEdge(pos, Direction.SOUTH);
            int width = east + west - 1;
            int length = north + south - 1;
            if (width > 9 || length > 9) {
                return;
            }
            if (width < 3 || length < 3) {
                return;
            }
            BlockPos neCorner = pos.func_177965_g(east).func_177964_d(north);
            BlockPos nwCorner = pos.func_177985_f(west).func_177964_d(north);
            BlockPos seCorner = pos.func_177965_g(east).func_177970_e(south);
            BlockPos swCorner = pos.func_177985_f(west).func_177970_e(south);
            this.nw = nwCorner.func_177982_a(1, 0, 1);
            this.se = seCorner.func_177982_a(-1, 0, -1);
            int wallWidth = width + 2;
            int wallLength = length + 2;
            this.width = wallWidth;
            this.length = wallLength;
            for (y = 0; y <= 1; ++y) {
                for (int x = 0; x < wallWidth; ++x) {
                    for (int z = 0; z < wallLength; ++z) {
                        if (y != 0 && x != 0 && z != 0 && x != wallWidth - 1 && z != wallLength - 1 || this.isSandBlock(world.func_180495_p(nwCorner.func_177977_b().func_177982_a(x, y, z)))) continue;
                        return;
                    }
                }
            }
            for (y = 0; y < 2; ++y) {
                if (!this.isSandBlock(world.func_180495_p(neCorner.func_177982_a(0, y + 1, 0)))) {
                    return;
                }
                if (!this.isSandBlock(world.func_180495_p(nwCorner.func_177982_a(0, y + 1, 0)))) {
                    return;
                }
                if (!this.isSandBlock(world.func_180495_p(seCorner.func_177982_a(0, y + 1, 0)))) {
                    return;
                }
                if (this.isSandBlock(world.func_180495_p(swCorner.func_177982_a(0, y + 1, 0)))) continue;
                return;
            }
            this.valid = true;
        }

        int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 9 && this.isEmptyBlock(this.world.func_180495_p(blockpos = pos.func_177967_a(facing, i))) && this.isSandBlock(this.world.func_180495_p(blockpos.func_177977_b())); ++i) {
            }
            BlockState state = this.world.func_180495_p(pos.func_177967_a(facing, i));
            return this.isSandBlock(state) ? i : 0;
        }

        boolean isEmptyBlock(BlockState state) {
            return state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        }

        boolean isSandBlock(BlockState state) {
            return state.func_177230_c().func_203417_a((ITag)Tags.Blocks.SANDSTONE) || state.func_177230_c().func_203417_a(AtumAPI.Tags.LIMESTONE_BRICKS);
        }

        boolean isValid() {
            return this.valid;
        }

        void placePortalBlocks() {
            for (BlockPos portalPos : BlockPos.Mutable.func_218278_a((BlockPos)this.nw, (BlockPos)this.se)) {
                this.world.func_180501_a(portalPos, AtumBlocks.PORTAL.func_176223_P(), 2);
            }
        }
    }
}

