/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.machines;

import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.blocks.lighting.AtumTorchBlock;
import com.teammetallurgy.atum.blocks.machines.tileentity.GodforgeTileEntity;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class GodforgeBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final EnumProperty<God> GOD = EnumProperty.func_177709_a((String)"god", God.class);

    public GodforgeBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200943_b(3.5f).func_235838_a_(state -> (Boolean)state.func_177229_b((Property)LIT) != false ? 13 : 0));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a(GOD, (Comparable)((Object)God.ANPUT)));
    }

    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new GodforgeTileEntity();
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof GodforgeTileEntity && player instanceof ServerPlayerEntity) {
            GodforgeTileEntity godForge = (GodforgeTileEntity)tileEntity;
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)godForge, (BlockPos)pos);
        }
        return ActionResultType.CONSUME;
    }

    public static boolean setLitGod(World world, BlockPos pos, BlockState originalState, boolean isLit, God god) {
        return world.func_180501_a(pos, (BlockState)((BlockState)originalState.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(isLit))).func_206870_a(GOD, (Comparable)((Object)god)), 3);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof GodforgeTileEntity) {
            ((GodforgeTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof GodforgeTileEntity) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((GodforgeTileEntity)tileEntity));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.2;
            double d2 = (double)pos.func_177952_p() + 0.5;
            if (rand.nextDouble() < 0.1) {
                world.func_184134_a(d0, d1, d2, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            Direction.Axis axis = direction.func_176740_k();
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = axis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.52 : d4;
            double d6 = rand.nextDouble() * 6.0 / 16.0;
            double d7 = axis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.52 : d4;
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            world.func_195594_a(AtumTorchBlock.GOD_FLAMES.get(state.func_177229_b(GOD)), d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    public boolean func_149740_M(@Nonnull BlockState state) {
        return true;
    }

    public int func_180641_l(@Nonnull BlockState blockState, World world, @Nonnull BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nonnull
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, LIT, GOD});
    }
}

