/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.machines;

import com.teammetallurgy.atum.api.recipe.IAtumRecipeType;
import com.teammetallurgy.atum.api.recipe.recipes.SpinningWheelRecipe;
import com.teammetallurgy.atum.blocks.machines.tileentity.SpinningWheelTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.misc.StackHelper;
import com.teammetallurgy.atum.misc.recipe.RecipeHelper;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class SpinningWheelBlock
extends ContainerBlock {
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final IntegerProperty SPOOL = IntegerProperty.func_177719_a((String)"spool", (int)0, (int)3);
    private static final BooleanProperty WHEEL = BooleanProperty.func_177716_a((String)"wheel");

    public SpinningWheelBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.2f).harvestTool(ToolType.AXE).harvestLevel(0));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)SPOOL, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WHEEL, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public TileEntity func_196283_a_(@Nonnull IBlockReader reader) {
        return new SpinningWheelTileEntity();
    }

    public void func_196270_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof SpinningWheelTileEntity) {
            SpinningWheelTileEntity spinningWheel = (SpinningWheelTileEntity)tileEntity;
            if (player.func_213453_ef()) {
                StackHelper.giveItem(player, Hand.MAIN_HAND, spinningWheel.func_70301_a(0).func_77946_l());
                StackHelper.giveItem(player, Hand.MAIN_HAND, spinningWheel.func_70301_a(1).func_77946_l());
                spinningWheel.func_70298_a(0, spinningWheel.func_70297_j_());
                spinningWheel.func_70298_a(1, spinningWheel.func_70297_j_());
                spinningWheel.input = new CompoundNBT();
                spinningWheel.rotations = 0;
                world.func_180501_a(pos, (BlockState)((BlockState)world.func_180495_p(pos).func_206870_a((Property)SPOOL, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WHEEL, (Comparable)Boolean.valueOf(false)), 2);
                spinningWheel.func_70296_d();
            }
        }
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult rayTraceResult) {
        TileEntity tileEntity = world.func_175625_s(pos);
        ItemStack heldStack = player.func_184586_b(hand);
        if (tileEntity instanceof SpinningWheelTileEntity && hand == Hand.MAIN_HAND) {
            SpinningWheelTileEntity spinningWheel = (SpinningWheelTileEntity)tileEntity;
            Direction facing = rayTraceResult.func_216354_b();
            if (facing == state.func_177229_b((Property)FACING)) {
                this.output(world, pos, player, spinningWheel);
            } else if (facing == Direction.UP) {
                if (spinningWheel.func_191420_l() && !heldStack.func_190926_b() && spinningWheel.func_94041_b(0, heldStack) && (Integer)state.func_177229_b((Property)SPOOL) < 3) {
                    ItemStack inputStack;
                    ItemStack copyStack = new ItemStack((IItemProvider)heldStack.func_77973_b(), 1);
                    boolean canInsert = false;
                    if (spinningWheel.input.isEmpty()) {
                        spinningWheel.input = copyStack.func_77955_b(new CompoundNBT());
                    }
                    if (StackHelper.areStacksEqualIgnoreSize(inputStack = ItemStack.func_199557_a((CompoundNBT)spinningWheel.input), heldStack)) {
                        canInsert = true;
                    } else if (!inputStack.func_190926_b() && world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.atum.spinning_wheel_recipe_in_progress", new Object[]{inputStack.func_200301_q()}).func_240699_a_(TextFormatting.RED), true);
                        world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187726_cu, SoundCategory.BLOCKS, 0.8f, 1.0f);
                    }
                    if (canInsert) {
                        spinningWheel.func_70299_a(0, copyStack);
                        if (!player.func_184812_l_()) {
                            heldStack.func_190918_g(1);
                        }
                        spinningWheel.func_70296_d();
                    }
                } else if (!spinningWheel.input.isEmpty()) {
                    ItemStack input = ItemStack.func_199557_a((CompoundNBT)spinningWheel.input);
                    Collection<SpinningWheelRecipe> recipes = RecipeHelper.getRecipes(world.func_199532_z(), IAtumRecipeType.SPINNING_WHEEL);
                    for (SpinningWheelRecipe spinningWheelRecipe : recipes) {
                        for (Ingredient ingredient : spinningWheelRecipe.func_192400_c()) {
                            for (ItemStack ingredientStack : ingredient.func_193365_a()) {
                                if (!StackHelper.areStacksEqualIgnoreSize(ingredientStack, input)) continue;
                                boolean isSpoolFull = false;
                                if (!spinningWheel.func_191420_l()) {
                                    world.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)WHEEL), 2);
                                    if ((Integer)state.func_177229_b((Property)SPOOL) < 3) {
                                        if (spinningWheelRecipe.getRotations() == spinningWheel.rotations) {
                                            spinningWheel.func_70298_a(0, 1);
                                            spinningWheel.rotations = 0;
                                            int count = ingredientStack.func_190916_E();
                                            float precentage = 3.0f / (float)count;
                                            int spoolSize = (Integer)state.func_177229_b((Property)SPOOL) + Math.round(precentage);
                                            world.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)SPOOL, (Comparable)Integer.valueOf(Math.min(3, spoolSize)))).func_206870_a((Property)WHEEL, (Comparable)Boolean.valueOf(false)), 2);
                                            if (spoolSize >= 3) {
                                                isSpoolFull = true;
                                            }
                                        } else if (!((Boolean)state.func_177229_b((Property)WHEEL)).booleanValue()) {
                                            ++spinningWheel.rotations;
                                            if (world.field_72995_K) {
                                                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187644_cT, SoundCategory.BLOCKS, 0.55f, 0.4f, true);
                                            }
                                        }
                                    }
                                }
                                if (!isSpoolFull) continue;
                                ItemStack copyOutput = spinningWheelRecipe.func_77572_b(spinningWheel);
                                ItemStack output = new ItemStack((IItemProvider)copyOutput.func_77973_b(), copyOutput.func_190916_E());
                                spinningWheel.func_70299_a(1, output);
                                spinningWheel.input = new CompoundNBT();
                            }
                        }
                    }
                    spinningWheel.func_70296_d();
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void output(World world, BlockPos pos, @Nullable PlayerEntity player, SpinningWheelTileEntity spinningWheel) {
        BlockState state = world.func_180495_p(pos);
        if ((Integer)state.func_177229_b((Property)SPOOL) == 3) {
            if (!world.field_72995_K && player != null) {
                StackHelper.giveItem(player, Hand.MAIN_HAND, spinningWheel.func_70301_a(1));
                spinningWheel.func_70298_a(1, spinningWheel.func_70297_j_());
            }
            spinningWheel.input = new CompoundNBT();
            world.func_180501_a(pos, (BlockState)((BlockState)state.func_235896_a_((Property)SPOOL)).func_206870_a((Property)WHEEL, (Comparable)Boolean.valueOf(false)), 2);
            spinningWheel.func_70296_d();
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)AtumBlocks.SPINNING_WHEEL);
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != state.func_177230_c()) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof SpinningWheelTileEntity) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
            }
            world.func_175713_t(pos);
        }
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(@Nonnull BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{FACING, SPOOL, WHEEL});
    }
}

