/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.trap.tileentity;

import com.teammetallurgy.atum.blocks.base.tileentity.InventoryBaseTileEntity;
import com.teammetallurgy.atum.blocks.trap.TrapBlock;
import com.teammetallurgy.atum.inventory.container.block.TrapContainer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.FurnaceFuelSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TrapTileEntity
extends InventoryBaseTileEntity
implements ITickableTileEntity {
    protected int burnTime;
    protected int currentItemBurnTime;
    protected boolean isDisabled = false;
    public boolean isInsidePyramid = true;
    public final IIntArray trapData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TrapTileEntity.this.burnTime;
                }
                case 1: {
                    return TrapTileEntity.this.currentItemBurnTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TrapTileEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    TrapTileEntity.this.currentItemBurnTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public TrapTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType, 1);
    }

    public void setDisabledStatus(boolean isDisabled) {
        this.isDisabled = isDisabled;
        if (this.field_145850_b != null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    AxisAlignedBB getFacingBoxWithRange(Direction facing, int range) {
        BlockPos pos = this.func_174877_v();
        Vector3i dir = facing.func_176730_m();
        return new AxisAlignedBB(pos).func_72321_a((double)(dir.func_177958_n() * range), (double)(dir.func_177956_o() * range), (double)(dir.func_177952_p() * range));
    }

    public void func_73660_a() {
        boolean isBurningCheck = this.isBurning();
        boolean isBurning = false;
        boolean canDamageEntity = false;
        World world = this.field_145850_b;
        if (world == null) {
            return;
        }
        if (!this.isDisabled && this.isBurning()) {
            Direction facing = (Direction)world.func_180495_p(this.field_174879_c).func_177229_b((Property)TrapBlock.FACING);
            Class entity = this.isInsidePyramid ? PlayerEntity.class : LivingEntity.class;
            List entities = world.func_217357_a(entity, this.getFacingBoxWithRange(facing, 1).func_186664_h(0.05));
            for (LivingEntity livingBase : entities) {
                if (livingBase instanceof PlayerEntity ? !((PlayerEntity)livingBase).func_184812_l_() : livingBase != null) {
                    canDamageEntity = true;
                    this.triggerTrap(world, facing, livingBase);
                    continue;
                }
                canDamageEntity = false;
            }
        }
        if (this.isInsidePyramid) {
            this.burnTime = 1;
        }
        if (this.isBurning() && !this.isDisabled && canDamageEntity && !this.isInsidePyramid) {
            --this.burnTime;
        }
        if (!world.field_72995_K && !this.isDisabled) {
            ItemStack fuel = (ItemStack)this.inventory.get(0);
            if (!(!this.isBurning() && fuel.func_190926_b() || this.isBurning())) {
                this.currentItemBurnTime = this.burnTime = ForgeHooks.getBurnTime((ItemStack)fuel) / 10;
                if (this.isBurning()) {
                    isBurning = true;
                    if (!fuel.func_190926_b()) {
                        fuel.func_190918_g(1);
                    }
                }
            }
            if (isBurningCheck != this.isBurning()) {
                isBurning = true;
            }
        }
        if (isBurning) {
            this.func_70296_d();
        }
    }

    protected void triggerTrap(World world, Direction facing, LivingEntity livingBase) {
    }

    boolean isBurning() {
        return this.burnTime > 0;
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        return super.func_70300_a(player) && !this.isInsidePyramid;
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        ItemStack fuel = (ItemStack)this.inventory.get(0);
        return !this.isInsidePyramid && (FurnaceTileEntity.func_213991_b((ItemStack)stack) || FurnaceFuelSlot.func_178173_c_((ItemStack)stack) && fuel.func_77973_b() != Items.field_151133_ar);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SUpdateTileEntityPacket packet) {
        super.onDataPacket(manager, packet);
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.burnTime = compound.func_74762_e("BurnTime");
        this.isDisabled = compound.func_74767_n("Disabled");
        this.isInsidePyramid = compound.func_74767_n("InPyramid");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.burnTime));
        compound.func_74757_a("Disabled", this.isDisabled);
        compound.func_74757_a("InPyramid", this.isInsidePyramid);
        return compound;
    }

    @Nonnull
    protected Container func_213906_a(int windowID, @Nonnull PlayerInventory playerInventory) {
        return new TrapContainer(windowID, playerInventory, this);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return !this.isInsidePyramid ? super.func_70298_a(index, count) : ItemStack.field_190927_a;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction direction) {
        return !this.isInsidePyramid ? super.getCapability(capability, direction) : LazyOptional.empty();
    }
}

