/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teammetallurgy.atum.entity.animal.CamelEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class CamelModel<T extends CamelEntity>
extends EntityModel<T> {
    private final ModelRenderer headModel;
    private final ModelRenderer body;
    private final ModelRenderer legBackRight;
    private final ModelRenderer legBackLeft;
    private final ModelRenderer legFrontRight;
    private final ModelRenderer legFrontLeft;
    private final ModelRenderer neckheadModelLower;
    private final ModelRenderer snout;
    private final ModelRenderer earRight;
    private final ModelRenderer earLeft;
    private final ModelRenderer hump1;
    private final ModelRenderer hump2;
    private final ModelRenderer tail;
    private final ModelRenderer chestRight;
    private final ModelRenderer chestLeft;
    public final ModelRenderer saddle1;
    public final ModelRenderer saddle2;

    public CamelModel(float size) {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.chestLeft = new ModelRenderer((Model)this, 45, 41);
        this.chestLeft.func_78793_a(5.5f, 3.0f, 3.0f);
        this.chestLeft.func_228301_a_(-3.0f, 0.0f, 0.0f, 8.0f, 8.0f, 3.0f, size);
        this.setRotateAngle(this.chestLeft, 0.0f, 1.5707964f, size);
        this.tail = new ModelRenderer((Model)this, 94, 9);
        this.tail.func_78793_a(0.0f, 2.0f, 10.0f);
        this.tail.func_228301_a_(-1.5f, -1.0f, 0.0f, 3.0f, 1.0f, 14.0f, size);
        this.setRotateAngle(this.tail, -1.5707964f, 0.0f, 0.0f);
        this.snout = new ModelRenderer((Model)this, 0, 0);
        this.snout.func_78793_a(0.0f, -10.0f, -8.0f);
        this.snout.func_228301_a_(-3.0f, -5.0f, -6.0f, 6.0f, 4.0f, 6.0f, size);
        this.body = new ModelRenderer((Model)this, 29, 0);
        this.body.func_78793_a(0.0f, 5.0f, 2.0f);
        this.body.func_228301_a_(-6.0f, -10.0f, -7.0f, 12.0f, 18.0f, 10.0f, size);
        this.setRotateAngle(this.body, 1.5707964f, 0.0f, 0.0f);
        this.hump2 = new ModelRenderer((Model)this, 74, 16);
        this.hump2.func_78793_a(0.0f, 0.0f, 0.0f);
        this.hump2.func_228301_a_(-3.0f, -5.0f, 6.0f, 6.0f, 10.0f, 2.0f, size);
        this.headModel = new ModelRenderer((Model)this, 0, 14);
        this.headModel.func_78793_a(0.0f, 7.0f, -8.0f);
        this.headModel.func_228301_a_(-3.0f, -16.0f, -8.0f, 6.0f, 14.0f, 6.0f, size);
        this.earRight = new ModelRenderer((Model)this, 30, 0);
        this.earRight.func_78793_a(0.0f, 0.0f, 0.0f);
        this.earRight.func_228301_a_(-4.0f, -16.0f, -6.0f, 1.0f, 3.0f, 2.0f, size);
        this.setRotateAngle(this.earRight, -0.08726646f, 0.0f, 0.0f);
        this.earLeft = new ModelRenderer((Model)this, 30, 5);
        this.earLeft.func_78793_a(0.0f, 0.0f, 0.0f);
        this.earLeft.func_228301_a_(3.0f, -16.0f, -6.0f, 1.0f, 3.0f, 2.0f, size);
        this.setRotateAngle(this.earLeft, -0.08726646f, 0.0f, 0.0f);
        this.chestRight = new ModelRenderer((Model)this, 45, 28);
        this.chestRight.func_78793_a(-8.5f, 3.0f, 3.0f);
        this.chestRight.func_228301_a_(-3.0f, 0.0f, 0.0f, 8.0f, 8.0f, 3.0f, size);
        this.setRotateAngle(this.chestRight, 0.0f, 1.5707964f, 0.0f);
        this.neckheadModelLower = new ModelRenderer((Model)this, 68, 30);
        this.neckheadModelLower.func_78793_a(0.0f, 0.0f, 0.0f);
        this.neckheadModelLower.func_228301_a_(-4.0f, -4.0f, -5.0f, 8.0f, 6.0f, 6.0f, size);
        this.hump1 = new ModelRenderer((Model)this, 74, 0);
        this.hump1.func_78793_a(0.0f, 0.0f, 0.0f);
        this.hump1.func_228301_a_(-4.0f, -6.0f, 3.0f, 8.0f, 12.0f, 3.0f, size);
        this.legBackRight = new ModelRenderer((Model)this, 29, 29);
        this.legBackRight.func_78793_a(3.5f, 10.0f, -5.0f);
        this.legBackRight.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, size);
        this.legBackLeft = new ModelRenderer((Model)this, 29, 29);
        this.legBackLeft.func_78793_a(-3.5f, 10.0f, -5.0f);
        this.legBackLeft.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, size);
        this.legFrontRight = new ModelRenderer((Model)this, 29, 29);
        this.legFrontRight.func_78793_a(3.5f, 10.0f, 6.0f);
        this.legFrontRight.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, size);
        this.legFrontLeft = new ModelRenderer((Model)this, 29, 29);
        this.legFrontLeft.func_78793_a(-3.5f, 10.0f, 6.0f);
        this.legFrontLeft.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, size);
        this.saddle1 = new ModelRenderer((Model)this, 101, 32);
        this.saddle1.func_78793_a(0.0f, 4.9f, 2.0f);
        this.saddle1.func_228301_a_(-4.0f, -6.0f, 6.0f, 8.0f, 12.0f, 2.0f, size);
        this.setRotateAngle(this.saddle1, 1.5707964f, 0.0f, 0.0f);
        this.saddle2 = new ModelRenderer((Model)this, 100, 48);
        this.saddle2.func_78793_a(0.0f, 5.0f, 2.0f);
        this.saddle2.func_228301_a_(-5.0f, 2.0f, 8.0f, 10.0f, 4.0f, 4.0f, size);
        this.setRotateAngle(this.saddle2, 1.5707964f, 0.0f, 0.0f);
        this.headModel.func_78792_a(this.snout);
        this.headModel.func_78792_a(this.earRight);
        this.headModel.func_78792_a(this.earLeft);
        this.headModel.func_78792_a(this.neckheadModelLower);
        this.body.func_78792_a(this.hump1);
        this.body.func_78792_a(this.hump2);
    }

    public void func_225598_a_(@Nonnull MatrixStack matrixStack, @Nonnull IVertexBuilder vertexBuilder, int limbSwing, int limbSwingAmount, float ageInTicks, float netheadModelYaw, float headModelPitch, float scale) {
        if (this.field_217114_e) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.71428573f, 0.64935064f, 0.7936508f);
            matrixStack.func_227861_a_(0.0, 1.3125, (double)0.22f);
            this.headModel.func_228309_a_(matrixStack, vertexBuilder, limbSwing, limbSwingAmount, ageInTicks, netheadModelYaw, headModelPitch, scale);
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.625f, 0.45454544f, 0.45454544f);
            matrixStack.func_227861_a_(0.0, 2.0625, 0.0);
            this.body.func_228309_a_(matrixStack, vertexBuilder, limbSwing, limbSwingAmount, ageInTicks, netheadModelYaw, headModelPitch, scale);
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.45454544f, 0.41322312f, 0.45454544f);
            matrixStack.func_227861_a_(0.0, 2.0625, 0.0);
            ImmutableList.of((Object)this.legBackRight, (Object)this.legBackLeft, (Object)this.legFrontRight, (Object)this.legFrontLeft, (Object)this.chestLeft, (Object)this.chestRight, (Object)this.saddle1, (Object)this.saddle2).forEach(model -> model.func_228309_a_(matrixStack, vertexBuilder, limbSwing, limbSwingAmount, ageInTicks, netheadModelYaw, headModelPitch, scale));
            matrixStack.func_227865_b_();
        } else {
            ImmutableList.of((Object)this.headModel, (Object)this.body, (Object)this.legBackRight, (Object)this.legBackLeft, (Object)this.legFrontRight, (Object)this.legFrontLeft, (Object)this.chestLeft, (Object)this.chestRight, (Object)this.saddle1, (Object)this.saddle2).forEach(model -> model.func_228309_a_(matrixStack, vertexBuilder, limbSwing, limbSwingAmount, ageInTicks, netheadModelYaw, headModelPitch, scale));
        }
    }

    public void setRotationAngles(@Nonnull T camel, float limbSwing, float limbSwingAmount, float ageInTicks, float netheadModelYaw, float headModelPitch) {
        boolean isSaddled;
        limbSwingAmount *= 0.65f;
        if (camel.func_184207_aI()) {
            this.headModel.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 0.025f * limbSwingAmount;
            Vector3d motion = camel.func_213322_ci();
            this.tail.field_78795_f = -45.5f + MathHelper.func_76133_a((double)(Math.pow(motion.field_72450_a, 2.0) + Math.pow(motion.field_72449_c, 2.0)));
        } else {
            this.tail.field_78795_f = -45.5f;
        }
        this.tail.field_78808_h = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 0.1f * limbSwingAmount;
        this.headModel.field_78795_f = headModelPitch * ((float)Math.PI / 180);
        this.headModel.field_78796_g = netheadModelYaw * ((float)Math.PI / 180);
        this.body.field_78795_f = 1.5707964f;
        this.legBackRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.legBackLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.legFrontRight.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.legFrontLeft.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        boolean isChild = camel.func_70631_g_();
        this.saddle1.field_78806_j = isSaddled = !isChild && camel.func_110257_ck();
        this.saddle2.field_78806_j = isSaddled;
        this.chestLeft.field_78806_j = ((CamelEntity)((Object)camel)).hasLeftCrate();
        this.chestRight.field_78806_j = ((CamelEntity)((Object)camel)).hasRightCrate();
    }

    private void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

