/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teammetallurgy.atum.client.model.entity.CamelModel;
import com.teammetallurgy.atum.entity.animal.CamelEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;

public class CamelDecorLayer
extends LayerRenderer<CamelEntity, CamelModel<CamelEntity>> {
    private static final ResourceLocation[] CAMEL_DECOR_TEXTURES = new ResourceLocation[]{new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_white.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_orange.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_magenta.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_light_blue.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_yellow.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_lime.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_pink.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_gray.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_light_gray.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_cyan.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_purple.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_blue.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_brown.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_green.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_red.png"), new ResourceLocation("atum", "textures/entity/camel_carpet/camel_carpet_black.png")};
    private final CamelModel<CamelEntity> model = new CamelModel(0.5f);

    public CamelDecorLayer(IEntityRenderer<CamelEntity, CamelModel<CamelEntity>> entityRenderer) {
        super(entityRenderer);
    }

    public void render(@Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int packedLight, CamelEntity camel, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DyeColor dyeColor = camel.getColor();
        if (dyeColor != null) {
            ResourceLocation location = CAMEL_DECOR_TEXTURES[dyeColor.func_196059_a()];
            ((CamelModel)this.func_215332_c()).func_217111_a(this.model);
            this.model.setRotationAngles(camel, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            IVertexBuilder ivertexbuilder = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)location));
            this.model.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

