/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.mobs;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.client.model.entity.CamelModel;
import com.teammetallurgy.atum.client.render.entity.layer.CamelArmorLayer;
import com.teammetallurgy.atum.client.render.entity.layer.CamelDecorLayer;
import com.teammetallurgy.atum.entity.animal.CamelEntity;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CamelRender
extends MobRenderer<CamelEntity, CamelModel<CamelEntity>> {
    private static final Map<String, ResourceLocation> CACHE = Maps.newHashMap();

    public CamelRender(EntityRendererManager renderManager) {
        super(renderManager, new CamelModel(0.0f), 0.7f);
        this.func_177094_a(new CamelDecorLayer((IEntityRenderer<CamelEntity, CamelModel<CamelEntity>>)this));
        this.func_177094_a(new CamelArmorLayer((IEntityRenderer<CamelEntity, CamelModel<CamelEntity>>)this));
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull CamelEntity camel) {
        String textureName = camel.getTexture();
        ResourceLocation location = CACHE.get(textureName);
        if (location == null) {
            location = new ResourceLocation("atum", "textures/entity/camel_" + textureName + ".png");
            CACHE.put(textureName, location);
        }
        return location;
    }
}

