/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.teammetallurgy.atum.entity.villager.AtumVillagerEntity;
import com.teammetallurgy.atum.entity.villager.AtumVillagerProfession;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockPosWrapper;
import net.minecraft.util.math.IPosWrapper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.ForgeEventFactory;

public class AtumFarmTask
extends Task<VillagerEntity> {
    @Nullable
    private BlockPos pos;
    private long taskCooldown;
    private int idleTime;
    private final List<BlockPos> farmableBlocks = Lists.newArrayList();

    public AtumFarmTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220944_e, (Object)MemoryModuleStatus.VALUE_PRESENT));
    }

    protected boolean shouldExecute(@Nonnull ServerWorld world, @Nonnull VillagerEntity owner) {
        if (!ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)owner) && !(owner instanceof AtumVillagerEntity)) {
            return false;
        }
        if (((AtumVillagerEntity)owner).getAtumVillagerData().getAtumProfession() != AtumVillagerProfession.FARMER.get()) {
            return false;
        }
        BlockPos.Mutable mutablePos = owner.func_233580_cy_().func_239590_i_();
        this.farmableBlocks.clear();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    mutablePos.func_189532_c(owner.func_226277_ct_() + (double)i, owner.func_226278_cu_() + (double)j, owner.func_226281_cx_() + (double)k);
                    if (!this.isValidPosForFarming((BlockPos)mutablePos, world)) continue;
                    this.farmableBlocks.add(new BlockPos((Vector3i)mutablePos));
                }
            }
        }
        this.pos = this.getNextPosForFarming(world);
        return this.pos != null;
    }

    @Nullable
    private BlockPos getNextPosForFarming(ServerWorld serverworld) {
        return this.farmableBlocks.isEmpty() ? null : this.farmableBlocks.get(serverworld.func_201674_k().nextInt(this.farmableBlocks.size()));
    }

    private boolean isValidPosForFarming(BlockPos pos, ServerWorld serverworld) {
        BlockState blockstate = serverworld.func_180495_p(pos);
        Block block = blockstate.func_177230_c();
        Block block1 = serverworld.func_180495_p(pos.func_177977_b()).func_177230_c();
        return block instanceof CropsBlock && ((CropsBlock)block).func_185525_y(blockstate) || blockstate.func_196958_f() && block1 instanceof FarmlandBlock;
    }

    protected void startExecuting(ServerWorld world, VillagerEntity entity, long gameTimeIn) {
        if (gameTimeIn > this.taskCooldown && this.pos != null) {
            entity.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new BlockPosWrapper(this.pos));
            entity.func_213375_cj().func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget((IPosWrapper)new BlockPosWrapper(this.pos), 0.5f, 1));
        }
    }

    protected void resetTask(ServerWorld world, VillagerEntity entity, long gameTimeIn) {
        entity.func_213375_cj().func_218189_b(MemoryModuleType.field_220951_l);
        entity.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
        this.idleTime = 0;
        this.taskCooldown = gameTimeIn + 40L;
    }

    protected void updateTask(ServerWorld world, VillagerEntity owner, long gameTime) {
        if (this.pos == null || this.pos.func_218137_a((IPosition)owner.func_213303_ch(), 1.0)) {
            if (this.pos != null && gameTime > this.taskCooldown) {
                BlockState blockstate = world.func_180495_p(this.pos);
                Block block = blockstate.func_177230_c();
                Block block1 = world.func_180495_p(this.pos.func_177977_b()).func_177230_c();
                if (block instanceof CropsBlock && ((CropsBlock)block).func_185525_y(blockstate)) {
                    world.func_225521_a_(this.pos, true, (Entity)owner);
                }
                if (blockstate.func_196958_f() && block1 instanceof FarmlandBlock && owner.func_175556_cs()) {
                    Inventory inventory = owner.func_213715_ed();
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        ItemStack itemstack = inventory.func_70301_a(i);
                        boolean flag = false;
                        if (!itemstack.func_190926_b()) {
                            if (itemstack.func_77973_b() == Items.field_151014_N) {
                                world.func_180501_a(this.pos, Blocks.field_150464_aj.func_176223_P(), 3);
                                flag = true;
                            } else if (itemstack.func_77973_b() == Items.field_151174_bG) {
                                world.func_180501_a(this.pos, Blocks.field_150469_bN.func_176223_P(), 3);
                                flag = true;
                            } else if (itemstack.func_77973_b() == Items.field_151172_bF) {
                                world.func_180501_a(this.pos, Blocks.field_150459_bM.func_176223_P(), 3);
                                flag = true;
                            } else if (itemstack.func_77973_b() == Items.field_185163_cU) {
                                world.func_180501_a(this.pos, Blocks.field_185773_cZ.func_176223_P(), 3);
                                flag = true;
                            } else if (itemstack.func_77973_b() instanceof IPlantable && ((IPlantable)itemstack.func_77973_b()).getPlantType((IBlockReader)world, this.pos) == PlantType.CROP) {
                                world.func_180501_a(this.pos, ((IPlantable)itemstack.func_77973_b()).getPlant((IBlockReader)world, this.pos), 3);
                                flag = true;
                            }
                        }
                        if (!flag) continue;
                        world.func_184148_a((PlayerEntity)null, (double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), SoundEvents.field_219626_bz, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        itemstack.func_190918_g(1);
                        if (!itemstack.func_190926_b()) break;
                        inventory.func_70299_a(i, ItemStack.field_190927_a);
                        break;
                    }
                }
                if (block instanceof CropsBlock && !((CropsBlock)block).func_185525_y(blockstate)) {
                    this.farmableBlocks.remove(this.pos);
                    this.pos = this.getNextPosForFarming(world);
                    if (this.pos != null) {
                        this.taskCooldown = gameTime + 20L;
                        owner.func_213375_cj().func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget((IPosWrapper)new BlockPosWrapper(this.pos), 0.5f, 1));
                        owner.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new BlockPosWrapper(this.pos));
                    }
                }
            }
            ++this.idleTime;
        }
    }

    protected boolean shouldContinueExecuting(@Nonnull ServerWorld world, @Nonnull VillagerEntity entity, long gameTimeIn) {
        return this.idleTime < 200;
    }
}

