/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.animal;

import com.teammetallurgy.atum.entity.ai.goal.FollowFlockLeaderGoal;
import com.teammetallurgy.atum.entity.animal.DesertWolfEntity;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumItems;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class QuailEntity
extends AnimalEntity {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{AtumItems.EMMER_SEEDS, Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;
    public int timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
    private QuailEntity flockLeader;
    private int groupSize = 1;

    public QuailEntity(EntityType<? extends QuailEntity> type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.6));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 1.4, 1.6));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, WolfEntity.class, 10.0f, 1.3, 1.6));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, DesertWolfEntity.class, 10.0f, 1.3, 1.6));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, MonsterEntity.class, 4.0f, 1.0, 1.4));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowFlockLeaderGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233821_d_, 0.32);
    }

    protected float func_213348_b(@Nonnull Pose pose, @Nonnull EntitySize size) {
        return this.func_70631_g_() ? size.field_220316_b * 0.5f : size.field_220316_b;
    }

    public QuailEntity func_241840_a(@Nonnull ServerWorld world, @Nonnull AgeableEntity ageableEntity) {
        return (QuailEntity)AtumEntities.QUAIL.func_200721_a((World)world);
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public int getMaxFlockSize() {
        return 6;
    }

    public boolean hasFlockLeader() {
        return this.flockLeader != null && this.flockLeader.func_70089_S();
    }

    public QuailEntity addToFlock(QuailEntity quail) {
        this.flockLeader = quail;
        quail.increaseGroupSize();
        return quail;
    }

    public void leaveGroup() {
        this.flockLeader.decreaseGroupSize();
        this.flockLeader = null;
    }

    private void increaseGroupSize() {
        ++this.groupSize;
    }

    private void decreaseGroupSize() {
        --this.groupSize;
    }

    public boolean canGroupGrow() {
        return this.isFlockLeader() && this.groupSize < this.getMaxFlockSize();
    }

    public void func_70071_h_() {
        List list;
        super.func_70071_h_();
        if (this.isFlockLeader() && this.field_70170_p.field_73012_v.nextInt(200) == 1 && (list = this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0))).size() <= 1) {
            this.groupSize = 1;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70122_E && vector3d.field_72448_b < 0.0) {
            this.func_213317_d(vector3d.func_216372_d(1.0, 0.6, 1.0));
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_70631_g_() && --this.timeUntilNextEgg <= 0) {
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_199703_a((IItemProvider)AtumItems.QUAIL_EGG);
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187660_W;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSource) {
        return SoundEvents.field_187666_Z;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187663_X;
    }

    protected void func_180429_a(@Nonnull BlockPos pos, @Nonnull BlockState block) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = compound.func_74762_e("EggLayTime");
        }
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        super.func_184232_k(passenger);
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        passenger.func_70107_b(this.func_226277_ct_() + (double)(0.1f * f), this.func_226283_e_(0.5) + passenger.func_70033_W() + 0.0, this.func_226281_cx_() - (double)(0.1f * f1));
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    public boolean isFlockLeader() {
        return this.groupSize > 1;
    }

    public boolean inRangeOfFlockLeader() {
        return this.func_70068_e((Entity)this.flockLeader) <= 121.0;
    }

    public void moveToFlockLeader() {
        if (this.hasFlockLeader()) {
            this.func_70661_as().func_75497_a((Entity)this.flockLeader, 1.0);
        }
    }

    public void func_212810_a(Stream<QuailEntity> quails) {
        quails.limit(this.getMaxFlockSize() - this.groupSize).filter(q -> q != this).forEach(quail -> quail.addToFlock(this));
    }

    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IServerWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        if (spawnData == null) {
            spawnData = new GroupData(this);
        } else {
            this.addToFlock(((GroupData)((Object)spawnData)).flockLeader);
        }
        return super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
    }

    public static class GroupData
    extends AgeableEntity.AgeableData {
        public final QuailEntity flockLeader;

        public GroupData(QuailEntity flockLeader) {
            super(true);
            this.flockLeader = flockLeader;
        }
    }
}

