/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.animal;

import com.teammetallurgy.atum.blocks.stone.limestone.LimestoneBlock;
import com.teammetallurgy.atum.blocks.wood.DeadwoodLogBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumLootTables;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ScarabEntity
extends MonsterEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(ScarabEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public ScarabEntity(EntityType<? extends ScarabEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new AIHideInBlock(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IServerWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason spawnReason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT nbt) {
        livingdata = super.func_213386_a(world, difficulty, spawnReason, livingdata, nbt);
        if (this.field_70146_Z.nextDouble() <= 0.002) {
            this.setVariant(1);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(24.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(3.0);
            this.func_70691_i(16.0f);
        } else {
            this.setVariant(0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(8.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(2.0);
        }
        return livingdata;
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187535_aY;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSource) {
        return SoundEvents.field_187590_ba;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187536_aZ;
    }

    protected void func_180429_a(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        this.func_184185_a(SoundEvents.field_187592_bb, 0.15f, 1.0f);
    }

    protected int func_70693_a(@Nonnull PlayerEntity player) {
        return this.getVariant() == 1 ? 30 : 3;
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        return this.getVariant() == 1 ? AtumLootTables.SCARAB_GOLDEN : AtumLootTables.SCARAB;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
        }
    }

    public float func_180484_a(@Nonnull BlockPos pos) {
        Block block = this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c();
        return block == AtumBlocks.LIMESTONE || block == AtumBlocks.DEADWOOD_LOG ? 10.0f : super.func_180484_a(pos);
    }

    public float func_213307_e(@Nonnull Pose pose) {
        return 0.1f;
    }

    public double func_70033_W() {
        return 0.1;
    }

    public static boolean canSpawn(EntityType<ScarabEntity> scarab, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (ScarabEntity.func_223324_d(scarab, (IWorld)world, (SpawnReason)spawnReason, (BlockPos)pos, (Random)random)) {
            PlayerEntity player = world.func_217366_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0, true);
            return player == null;
        }
        return false;
    }

    @Nonnull
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    static class AIHideInBlock
    extends RandomWalkingGoal {
        private Direction facing;
        private boolean doMerge;

        AIHideInBlock(ScarabEntity scarab) {
            super((CreatureEntity)scarab, 1.0, 10);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.field_75457_a.func_70638_az() != null) {
                return false;
            }
            if (!this.field_75457_a.func_70661_as().func_75500_f()) {
                return false;
            }
            Random random = this.field_75457_a.func_70681_au();
            if (ForgeEventFactory.getMobGriefingEvent((World)this.field_75457_a.field_70170_p, (Entity)this.field_75457_a) && random.nextInt(10) == 0) {
                this.facing = Direction.func_239631_a_((Random)random);
                BlockPos pos = new BlockPos(this.field_75457_a.func_226277_ct_(), this.field_75457_a.func_226278_cu_() + 0.5, this.field_75457_a.func_226281_cx_()).func_177972_a(this.facing);
                BlockState state = this.field_75457_a.field_70170_p.func_180495_p(pos);
                if (state.func_177230_c() == AtumBlocks.LIMESTONE || state.func_177230_c() == AtumBlocks.DEADWOOD_LOG) {
                    this.doMerge = true;
                    return true;
                }
            }
            this.doMerge = false;
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.doMerge && super.func_75253_b();
        }

        public void func_75249_e() {
            if (!this.doMerge) {
                super.func_75249_e();
            } else {
                World world = this.field_75457_a.field_70170_p;
                BlockPos pos = new BlockPos(this.field_75457_a.func_226277_ct_(), this.field_75457_a.func_226278_cu_() + 0.5, this.field_75457_a.func_226281_cx_()).func_177972_a(this.facing);
                BlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() == AtumBlocks.LIMESTONE) {
                    world.func_180501_a(pos, (BlockState)AtumBlocks.LIMESTONE.func_176223_P().func_206870_a((Property)LimestoneBlock.HAS_SCARAB, (Comparable)Boolean.valueOf(true)), 3);
                    this.field_75457_a.func_70656_aK();
                    this.field_75457_a.func_70106_y();
                }
                if (state.func_177230_c() == AtumBlocks.DEADWOOD_LOG) {
                    world.func_180501_a(pos, (BlockState)AtumBlocks.DEADWOOD_LOG.func_176223_P().func_206870_a((Property)DeadwoodLogBlock.HAS_SCARAB, (Comparable)Boolean.valueOf(true)), 3);
                    this.field_75457_a.func_70656_aK();
                    this.field_75457_a.func_70106_y();
                }
            }
        }
    }
}

