/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.projectile;

import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.blocks.lighting.AtumTorchBlock;
import com.teammetallurgy.atum.entity.projectile.arrow.CustomArrow;
import com.teammetallurgy.atum.entity.undead.PharaohEntity;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.items.artifacts.horus.HorusAscensionItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;

@Mod.EventBusSubscriber(modid="atum")
public class PharaohOrbEntity
extends CustomArrow
implements IEntityAdditionalSpawnData {
    private final God god;
    private static int berserkTimer;
    private static float berserkDamage;

    public PharaohOrbEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(AtumEntities.PHARAOH_ORB, world);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
        this.func_70239_b(this.getOrbDamage());
        this.god = God.getGodByName(spawnEntity.getAdditionalData().func_218666_n());
    }

    public PharaohOrbEntity(EntityType<? extends PharaohOrbEntity> entityType, World world) {
        super(entityType, world);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
        this.func_70239_b(this.getOrbDamage());
        this.god = God.ATEM;
    }

    public PharaohOrbEntity(World world, PharaohEntity shooter, God god) {
        super(AtumEntities.PHARAOH_ORB, world, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.3f, shooter.func_226281_cx_());
        this.func_212361_a((Entity)shooter);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
        this.func_70239_b(this.getOrbDamage());
        this.god = god;
    }

    public God getGod() {
        return this.god;
    }

    public int getOrbDamage() {
        return 6;
    }

    @Override
    @Nonnull
    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    protected SoundEvent func_213867_k() {
        return SoundEvents.field_187541_bC;
    }

    protected void func_225516_i_() {
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.01, 0.0));
        if (this.getGod() == God.MONTU) {
            if (berserkTimer > 1) {
                --berserkTimer;
            }
            if (berserkTimer == 1) {
                berserkDamage = 0.0f;
                berserkTimer = 0;
            }
        }
        if (this.field_70170_p instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
            serverWorld.func_195598_a(AtumTorchBlock.GOD_FLAMES.get((Object)this.getGod()), this.func_226277_ct_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + this.field_70170_p.field_73012_v.nextDouble() * (double)this.func_213302_cg(), this.func_226281_cx_() + (this.field_70170_p.field_73012_v.nextDouble() - 0.5) * (double)this.func_213311_cf(), 2, 0.0, 0.0, 0.0, 0.01);
        }
    }

    public static DamageSource causeOrbDamage(PharaohOrbEntity pharaohOrbEntity, @Nullable Entity indirectEntity) {
        return new IndirectEntityDamageSource("atum_pharaoh_orb", (Entity)pharaohOrbEntity, indirectEntity).func_76351_m().func_76349_b();
    }

    protected void func_213868_a(EntityRayTraceResult rayTrace) {
        Entity entity = rayTrace.func_216348_a();
        float f = (float)this.func_213322_ci().func_72433_c();
        int i = MathHelper.func_76143_f((double)MathHelper.func_151237_a((double)((double)f * this.func_70242_d()), (double)0.0, (double)2.147483647E9));
        Entity entity1 = this.func_234616_v_();
        DamageSource damagesource = PharaohOrbEntity.causeOrbDamage(this, entity1);
        if (entity1 instanceof LivingEntity) {
            ((LivingEntity)entity1).func_130011_c(entity);
        }
        int fireTimer = entity.func_223314_ad();
        if (!(entity instanceof PharaohEntity) && entity.func_70097_a(damagesource, (float)i)) {
            if (entity instanceof LivingEntity) {
                Vector3d vector3d;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.field_70256_ap > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.field_70256_ap * 0.6)).func_189985_c() > 0.0) {
                    livingEntity.func_70024_g(vector3d.field_72450_a, 0.1, vector3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingEntity, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingEntity);
                }
                this.func_184548_a(livingEntity);
                Entity shooter = this.func_234616_v_();
                if (!this.field_70170_p.field_72995_K && shooter instanceof LivingEntity) {
                    this.doGodSpecificEffect(this.getGod(), (LivingEntity)shooter, livingEntity);
                }
                if (entity1 != null && livingEntity != entity1 && livingEntity instanceof PlayerEntity && entity1 instanceof ServerPlayerEntity && !this.func_174814_R()) {
                    ((ServerPlayerEntity)entity1).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                }
            }
            this.func_184185_a(this.func_213867_k(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.func_213874_s() <= 0) {
                this.func_70106_y();
            }
        } else {
            entity.func_241209_g_(fireTimer);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                this.func_70106_y();
            }
        }
        this.func_70106_y();
    }

    public void doGodSpecificEffect(God god, LivingEntity shooter, LivingEntity target) {
        switch (god) {
            case ANPUT: {
                target.func_195064_c(new EffectInstance(Effects.field_76438_s, 80, 1));
                break;
            }
            case ANUBIS: {
                target.func_195064_c(new EffectInstance(Effects.field_82731_v, 60, 1));
                break;
            }
            case ATEM: {
                target.func_195064_c(new EffectInstance(Effects.field_76433_i, 1, 0));
                break;
            }
            case GEB: {
                target.func_233627_a_(1.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                break;
            }
            case HORUS: {
                target.func_195064_c(new EffectInstance(Effects.field_76419_f, 60, 1));
                break;
            }
            case ISIS: {
                shooter.func_70691_i(10.0f);
                break;
            }
            case NUIT: {
                target.func_195064_c(new EffectInstance(Effects.field_76440_q, 60, 0));
                break;
            }
            case NEPTHYS: {
                target.func_195064_c(new EffectInstance(Effects.field_76437_t, 120));
                break;
            }
            case PTAH: {
                this.applyReverseKnockback(target, 2.0f, MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))));
                break;
            }
            case RA: {
                target.func_70015_d(3);
                break;
            }
            case SETH: {
                target.func_195064_c(new EffectInstance(Effects.field_76436_u, 100, 0));
                break;
            }
            case SHU: {
                HorusAscensionItem.knockUp(target, shooter, this.field_70146_Z);
                break;
            }
            case TEFNUT: {
                target.func_195064_c(new EffectInstance(Effects.field_76431_k, 100));
                break;
            }
        }
    }

    public void applyReverseKnockback(LivingEntity target, float reverseStrength, double ratioX, double ratioZ) {
        if (!((reverseStrength = (float)((double)reverseStrength * (1.0 - target.func_233637_b_(Attributes.field_233820_c_)))) <= 0.0f)) {
            target.field_70160_al = true;
            Vector3d vector3d = target.func_213322_ci();
            Vector3d vector3d1 = new Vector3d(ratioX, 0.0, ratioZ).func_72432_b().func_186678_a((double)reverseStrength);
            target.func_213293_j(vector3d.field_72450_a / 2.0 - vector3d1.field_72450_a, target.func_233570_aj_() ? -Math.min(0.4, vector3d.field_72448_b / 2.0 + (double)reverseStrength) : vector3d.field_72448_b, -(vector3d.field_72449_c / 2.0 - vector3d1.field_72449_c));
        }
    }

    @SubscribeEvent
    public static void onBerserk(LivingHurtEvent event) {
        Entity immediateSource = event.getSource().func_76364_f();
        if (immediateSource instanceof PharaohOrbEntity && ((PharaohOrbEntity)immediateSource).getGod() == God.MONTU) {
            if (berserkTimer == 0) {
                event.setAmount(event.getAmount());
                berserkDamage = event.getAmount() / 10.0f + event.getAmount();
            } else {
                event.setAmount(berserkDamage += event.getAmount() / 10.0f);
            }
            berserkTimer = 80;
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("atum", "textures/entity/orb/orb_" + (this.getGod() != null ? this.getGod().getName() : God.ATEM.getName()) + ".png");
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_180714_a(this.god.getName());
    }

    public void readSpawnData(PacketBuffer additionalData) {
    }
}

