/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.stone;

import com.teammetallurgy.atum.entity.ITexture;
import com.teammetallurgy.atum.entity.stone.StoneBaseEntity;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.misc.StackHelper;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class StoneguardEntity
extends StoneBaseEntity
implements ITexture {
    private static final ResourceLocation STONEGUARD_IRON_TEXTURE = new ResourceLocation("atum", "textures/entity/stoneguard_derp.png");
    private static final AttributeModifier SHIELD_ARMOR = new AttributeModifier(UUID.fromString("29c9fac8-7da1-43c0-95e7-4a3cae9bcbef"), "Stoneguard shield armor", 4.0, AttributeModifier.Operation.ADDITION);

    public StoneguardEntity(EntityType<? extends StoneguardEntity> entityType, World world) {
        super(entityType, world);
        this.field_70728_aV = 8;
        this.func_98053_h(true);
        new GroundPathNavigator((MobEntity)this, world).func_189566_q().func_186317_a(true);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return StoneguardEntity.getBaseAttributes().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233826_i_, 10.0);
    }

    @Override
    protected void setFriendlyAttributes() {
        super.setFriendlyAttributes();
        AttributeModifier FRIENDLY_HEALTH = new AttributeModifier(UUID.fromString("41d44fff-f8a8-47c5-a753-d7eb9f715d40"), "Friendly Stoneguard health", 30.0, AttributeModifier.Operation.ADDITION);
        this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(FRIENDLY_HEALTH);
        this.func_70691_i(30.0f);
    }

    protected void func_213333_a(@Nonnull DamageSource source, int lootingModifier, boolean wasRecentlyHit) {
        if (this.isPlayerCreated()) {
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                ItemStack stack = this.func_184582_a(slot);
                if (stack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)stack) || !wasRecentlyHit) continue;
                this.func_70099_a(stack, 0.0f);
            }
        } else {
            super.func_213333_a(source, lootingModifier, wasRecentlyHit);
        }
    }

    protected void func_180481_a(@Nonnull DifficultyInstance difficulty) {
        int randomWeapon = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)3);
        this.setStoneguardEquipment(randomWeapon);
    }

    private void setStoneguardEquipment(int randomWeapon) {
        if (randomWeapon != 2) {
            ModifiableAttributeInstance attribute;
            this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)AtumItems.STONEGUARD_SHIELD));
            if (!this.field_70170_p.field_72995_K && (attribute = this.func_110148_a(Attributes.field_233821_d_)) != null && !attribute.func_180374_a(SHIELD_ARMOR)) {
                this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(SHIELD_ARMOR);
            }
        }
        switch (randomWeapon) {
            case 0: {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)AtumItems.STONEGUARD_SWORD));
                break;
            }
            case 1: {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)AtumItems.STONEGUARD_CLUB));
                break;
            }
            case 2: {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)AtumItems.STONEGUARD_GREATSWORD));
                break;
            }
            case 3: {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)AtumItems.STONEGUARD_KHOPESH));
            }
        }
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IServerWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason spawnReason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT nbt) {
        livingdata = super.func_213386_a(world, difficulty, spawnReason, livingdata, nbt);
        if (!this.isPlayerCreated()) {
            this.func_180481_a(difficulty);
            int variant = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)7);
            this.setVariant(variant);
        } else {
            this.setVariant(8);
        }
        return livingdata;
    }

    public boolean func_230292_f_(@Nonnull PlayerEntity player) {
        return this.getVariant() != 8;
    }

    @Override
    @Nonnull
    protected ActionResultType func_230254_b_(PlayerEntity player, @Nonnull Hand hand) {
        if (this.isPlayerCreated() && player.func_213453_ef() && player.func_184586_b(hand).func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                for (ItemStack held : this.func_184214_aD()) {
                    StackHelper.giveItem(player, hand, held);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    public String getTexture() {
        String customName;
        if (this.func_145818_k_() && this.func_200201_e() != null && ((customName = this.func_200201_e().getString()).equalsIgnoreCase("iron") || customName.equalsIgnoreCase("nutz") || customName.equalsIgnoreCase("vequinox"))) {
            return STONEGUARD_IRON_TEXTURE.toString();
        }
        return new ResourceLocation("atum", "textures/entity/stoneguard_" + this.getVariant() + ".png").toString();
    }
}

