/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.undead;

import com.teammetallurgy.atum.entity.ITexture;
import com.teammetallurgy.atum.entity.projectile.SmallBoneEntity;
import com.teammetallurgy.atum.entity.undead.UndeadBaseEntity;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BonestormEntity
extends UndeadBaseEntity
implements ITexture {
    private static final ResourceLocation BONESTORM_TEXTURE = new ResourceLocation("atum", "textures/entity/bonestorm.png");
    private String texturePath;
    private float heightOffset = 0.2f;
    private int heightOffsetUpdateTime;

    public BonestormEntity(EntityType<? extends BonestormEntity> entityType, World world) {
        super(entityType, world);
        this.field_70728_aV = 8;
        this.func_98053_h(false);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new AIBoneAttack(this));
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 15.0).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, 0.24).func_233815_a_(Attributes.field_233819_b_, 30.0);
    }

    @Override
    protected float getBurnDamage() {
        return 0.5f;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187858_fe;
    }

    @Override
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSource) {
        return SoundEvents.field_187862_fg;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187860_ff;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        LivingEntity livingBase;
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
        }
        if ((livingBase = this.func_70638_az()) != null && livingBase.func_226278_cu_() + (double)livingBase.func_70047_e() > this.func_226278_cu_() + (double)this.func_70047_e() + (double)this.heightOffset) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, ((double)0.3f - this.func_213322_ci().field_72448_b) * (double)0.3f, 0.0));
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.texturePath == null) {
            this.texturePath = BONESTORM_TEXTURE.toString();
        }
        return this.texturePath;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    private static class AIBoneAttack
    extends Goal {
        private final BonestormEntity bonestorm;
        private int attackStep;
        private int attackTime;

        private AIBoneAttack(BonestormEntity bonestorm) {
            this.bonestorm = bonestorm;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingBase = this.bonestorm.func_70638_az();
            return livingBase != null && livingBase.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity livingBase = this.bonestorm.func_70638_az();
            if (livingBase != null) {
                double distance = this.bonestorm.func_70068_e((Entity)livingBase);
                if (distance < 4.0) {
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.bonestorm.func_70652_k((Entity)livingBase);
                    }
                    this.bonestorm.func_70605_aq().func_75642_a(livingBase.func_226277_ct_(), livingBase.func_226278_cu_(), livingBase.func_226281_cx_(), 1.0);
                } else if (distance < this.getFollowDistance() * this.getFollowDistance()) {
                    double boneX = livingBase.func_226277_ct_() - this.bonestorm.func_226277_ct_();
                    double boneY = livingBase.func_174813_aQ().field_72338_b + (double)(livingBase.func_213302_cg() / 2.0f) - (this.bonestorm.func_226278_cu_() + (double)(this.bonestorm.func_213302_cg() / 2.0f));
                    double boneZ = livingBase.func_226281_cx_() - this.bonestorm.func_226281_cx_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)distance)) * 0.5f;
                            this.bonestorm.field_70170_p.func_184133_a(null, livingBase.func_233580_cy_(), SoundEvents.field_187864_fh, SoundCategory.HOSTILE, 0.7f, (this.bonestorm.field_70146_Z.nextFloat() - this.bonestorm.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                            for (int i = 0; i < 1; ++i) {
                                SmallBoneEntity entitySmallBone = new SmallBoneEntity(this.bonestorm.field_70170_p, (LivingEntity)this.bonestorm, boneX + this.bonestorm.func_70681_au().nextGaussian() * (double)f, boneY, boneZ + this.bonestorm.func_70681_au().nextGaussian() * (double)f);
                                entitySmallBone.func_70107_b(entitySmallBone.func_226277_ct_(), this.bonestorm.func_226278_cu_() + (double)(this.bonestorm.func_213302_cg() / 2.0f) + 0.5, entitySmallBone.func_226281_cx_());
                                this.bonestorm.field_70170_p.func_217376_c((Entity)entitySmallBone);
                            }
                        }
                    }
                    this.bonestorm.func_70671_ap().func_75651_a((Entity)livingBase, 10.0f, 10.0f);
                } else {
                    this.bonestorm.func_70661_as().func_75499_g();
                    this.bonestorm.func_70605_aq().func_75642_a(livingBase.func_226277_ct_(), livingBase.func_226278_cu_(), livingBase.func_226281_cx_(), 1.0);
                }
            }
            super.func_75246_d();
        }

        private double getFollowDistance() {
            return this.bonestorm.func_233637_b_(Attributes.field_233819_b_);
        }
    }
}

