/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.villager;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;

public enum Race implements IStringSerializable
{
    HUMAN("human", 1.0, 18);

    private static final Map<String, Race> BY_NAME;
    private final String name;
    private final double spawnWeightPercentage;
    private final int variantAmount;

    private Race(String name, double spawnWeightPercentage, int variantAmount) {
        this.name = name;
        this.spawnWeightPercentage = spawnWeightPercentage;
        this.variantAmount = variantAmount;
    }

    public static Race getTypeFromName(String name) {
        return BY_NAME.get(name);
    }

    public String getName() {
        return this.name;
    }

    public double getSpawnWeightPercentage() {
        return this.spawnWeightPercentage;
    }

    public int getVariantAmount() {
        return this.variantAmount;
    }

    public static Race getRandomRaceWeighted() {
        int idx;
        Race[] races = Race.values();
        double r = Math.random();
        for (idx = 0; idx < races.length - 1 && !((r -= races[idx].getSpawnWeightPercentage()) <= 0.0); ++idx) {
        }
        return races[idx];
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    static {
        BY_NAME = (Map)Util.func_200696_a((Object)Maps.newHashMap(), nameToTypeMap -> {
            for (Race race : Race.values()) {
                nameToTypeMap.put(race.name, race);
            }
        });
    }
}

