/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.misc.AtumRegistry;
import com.teammetallurgy.atum.world.biome.AtumBiomeMaker;
import com.teammetallurgy.atum.world.biome.BiomeRegion;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class AtumBiomes {
    public static final RegistryKey<Biome> DEAD_OASIS = AtumBiomes.registerBiome(AtumBiomeMaker.makeDeadOasis("dead_oasis"), "dead_oasis", BiomeRegion.STRANGE_SANDS);
    public static final RegistryKey<Biome> DENSE_WOODS = AtumBiomes.registerBiome(AtumBiomeMaker.makeDenseWoods("dense_woods"), "dense_woods", 10, BiomeRegion.DESSICATED_WOODS);
    public static final RegistryKey<Biome> SPARSE_WOODS = AtumBiomes.registerBiome(AtumBiomeMaker.makeSparseWoods("sparse_woods"), "sparse_woods", 10, BiomeRegion.DESSICATED_WOODS);
    public static final RegistryKey<Biome> DRIED_RIVER = AtumBiomes.registerBiome(AtumBiomeMaker.makeDriedRiver("dried_river"), "dried_river", BiomeRegion.STRANGE_SANDS);
    public static final RegistryKey<Biome> LIMESTONE_CRAGS = AtumBiomes.registerBiome(AtumBiomeMaker.makeLimestoneCrags("limestone_crags"), "limestone_crags", 3, BiomeRegion.LIMESTONE_PEAKS);
    public static final RegistryKey<Biome> LIMESTONE_MOUNTAINS = AtumBiomes.registerBiome(AtumBiomeMaker.makeLimestoneMountain("limestone_mountains"), "limestone_mountains", 5, BiomeRegion.LIMESTONE_PEAKS);
    public static final RegistryKey<Biome> OASIS = AtumBiomes.registerBiome(AtumBiomeMaker.makeOasis("oasis"), "oasis", BiomeRegion.STRANGE_SANDS);
    public static final RegistryKey<Biome> SAND_DUNES = AtumBiomes.registerBiome(AtumBiomeMaker.makeSandDunes("sand_dunes"), "sand_dunes", 15, BiomeRegion.STRANGE_SANDS);
    public static final RegistryKey<Biome> SAND_HILLS = AtumBiomes.registerBiome(AtumBiomeMaker.makeSandHills("sand_hills"), "sand_hills", 10, BiomeRegion.STRANGE_SANDS);
    public static final RegistryKey<Biome> SAND_PLAINS = AtumBiomes.registerBiome(AtumBiomeMaker.makeSandPlains("sand_plains"), "sand_plains", 30, BiomeRegion.STRANGE_SANDS);

    public static RegistryKey<Biome> registerBiome(Biome biome, String biomeName, BiomeRegion biomeRegion) {
        return AtumBiomes.registerBiome(biome, biomeName, 0, biomeRegion);
    }

    public static RegistryKey<Biome> registerBiome(Biome biome, String biomeName, int weight, BiomeRegion biomeRegion) {
        AtumRegistry.registerBiome(biome, biomeName);
        if (weight > 0) {
            new AtumConfig.Biome(AtumConfig.BUILDER, biomeName, weight);
        }
        return AtumRegistry.registerBiomeKey(biomeName);
    }

    public static void addBiomeTags() {
        for (RegistryKey<Biome> biome : AtumRegistry.BIOME_KEYS) {
            BiomeDictionary.addTypes(biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeTags.ATUM});
            if (biome == OASIS) continue;
            BiomeDictionary.addTypes(biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY});
        }
        BiomeDictionary.addTypes(DEAD_OASIS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeTags.OASIS, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.RARE});
        BiomeDictionary.addTypes(DENSE_WOODS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes(SPARSE_WOODS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes(DRIED_RIVER, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER});
        BiomeDictionary.addTypes(LIMESTONE_CRAGS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.RARE});
        BiomeDictionary.addTypes(LIMESTONE_MOUNTAINS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN});
        BiomeDictionary.addTypes(OASIS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeTags.OASIS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.RARE});
        BiomeDictionary.addTypes(SAND_DUNES, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS});
        BiomeDictionary.addTypes(SAND_HILLS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS});
        BiomeDictionary.addTypes(SAND_PLAINS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
    }

    public static class BiomeTags {
        public static final BiomeDictionary.Type ATUM = BiomeDictionary.Type.getType((String)"ATUM", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
        public static final BiomeDictionary.Type OASIS = BiomeDictionary.Type.getType((String)"OASIS", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
    }
}

