/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.teammetallurgy.atum.blocks.wood.DeadwoodLogBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.gen.feature.AnputsFingersFeature;
import com.teammetallurgy.atum.world.gen.feature.BonusCrateFeature;
import com.teammetallurgy.atum.world.gen.feature.DeadwoodFeature;
import com.teammetallurgy.atum.world.gen.feature.DirtyBoneFossilsFeature;
import com.teammetallurgy.atum.world.gen.feature.LakeFeature;
import com.teammetallurgy.atum.world.gen.feature.LimestoneDungeonsFeature;
import com.teammetallurgy.atum.world.gen.feature.LimestoneSpikeFeature;
import com.teammetallurgy.atum.world.gen.feature.SandLayerFeature;
import com.teammetallurgy.atum.world.gen.feature.StartStructureFeature;
import com.teammetallurgy.atum.world.gen.feature.tree.AtumTreeFeature;
import com.teammetallurgy.atum.world.gen.feature.tree.PalmFoliagePlacer;
import com.teammetallurgy.atum.world.gen.feature.tree.PalmTrunkPlacer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.ColumnBlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtumFeatures {
    private static final List<Feature<?>> FEATURES = new ArrayList();
    public static final Feature<BlockStateFeatureConfig> SURFACE_LAVA_LAKE = AtumFeatures.register("surface_lava_lake", new LakeFeature((Codec<BlockStateFeatureConfig>)BlockStateFeatureConfig.field_236455_a_));
    public static final Feature<BaseTreeFeatureConfig> ATUM_TREE = AtumFeatures.register("atum_tree", new AtumTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_));
    public static final BonusCrateFeature BONUS_CRATE = AtumFeatures.register("bonus_crate", new BonusCrateFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final StartStructureFeature START_STRUCTURE = AtumFeatures.register("start_structure", new StartStructureFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final DirtyBoneFossilsFeature DIRTY_BONE_FOSSILS = AtumFeatures.register("dirty_bone_fossil", new DirtyBoneFossilsFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final LimestoneDungeonsFeature LIMESTONE_DUNGEONS = AtumFeatures.register("limestone_dungeon", new LimestoneDungeonsFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final DeadwoodFeature DEADWOOD_FEATURE = AtumFeatures.register("deadwood_tree", new DeadwoodFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final Feature<NoFeatureConfig> LIMESTONE_SPIKE = AtumFeatures.register("limestone_spike", new LimestoneSpikeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final Feature<BlockClusterFeatureConfig> ANPUTS_FINGERS = AtumFeatures.register("anputs_fingers", new AnputsFingersFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_));
    public static final Feature<NoFeatureConfig> SAND_LAYER = AtumFeatures.register("sand_layer", new SandLayerFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final BlockClusterFeatureConfig OASIS_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.OASIS_GRASS.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig DENSE_DRY_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.DRY_GRASS.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(30).func_227322_d_();
    public static final BlockClusterFeatureConfig SPARSE_DRY_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.DRY_GRASS.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig DRY_TALL_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.TALL_DRY_GRASS.func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(20).func_227322_d_();
    public static final BlockClusterFeatureConfig SPARSE_TALL_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.TALL_DRY_GRASS.func_176223_P()), (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(2).func_227322_d_();
    public static final BlockClusterFeatureConfig ANPUTS_FINGERS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.ANPUTS_FINGERS.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(10).func_227322_d_();
    public static final BlockClusterFeatureConfig PAPYRUS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.PAPYRUS.func_176223_P()), (BlockPlacer)new ColumnBlockPlacer(1, 2)).func_227315_a_(8).func_227318_b_(2).func_227321_c_(0).func_227323_d_(2).func_227320_c_().func_227322_d_();
    public static final BaseTreeFeatureConfig PALM_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.PALM_LOG.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.PALM_LEAVES.func_176223_P()), (FoliagePlacer)new PalmFoliagePlacer(0.1f), (AbstractTrunkPlacer)new PalmTrunkPlacer(4, 1, 5, 0.25f), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig PALM_TREE_CONFIG_SAPLING = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.PALM_LOG.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.PALM_LEAVES.func_176223_P()), (FoliagePlacer)new PalmFoliagePlacer(0.1f), (AbstractTrunkPlacer)new PalmTrunkPlacer(4, 1, 5, 0.0f), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig DEAD_PALM_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider((BlockState)AtumBlocks.DEADWOOD_LOG.func_176223_P().func_206870_a((Property)DeadwoodLogBlock.HAS_SCARAB, (Comparable)Boolean.valueOf(true))), (BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.DRY_LEAVES.func_176223_P()), (FoliagePlacer)new PalmFoliagePlacer(0.0f), (AbstractTrunkPlacer)new PalmTrunkPlacer(4, 1, 5, 0.0f), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0)).func_236700_a_().func_225568_b_();
    public static final LiquidsConfig WATER_SPRING_CONFIG = new LiquidsConfig(Fluids.field_204546_a.func_207188_f(), true, 4, 1, (Set)ImmutableSet.of((Object)AtumBlocks.LIMESTONE));
    public static final LiquidsConfig LAVA_SPRING_CONFIG = new LiquidsConfig(Fluids.field_204547_b.func_207188_f(), true, 4, 1, (Set)ImmutableSet.of((Object)AtumBlocks.LIMESTONE));
    public static final BlockClusterFeatureConfig SHRUB_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.SHRUB.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(3).func_227322_d_();
    public static final BlockClusterFeatureConfig WEED_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AtumBlocks.WEED.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(3).func_227322_d_();

    private static <C extends IFeatureConfig, F extends Feature<C>> F register(String name, F feature) {
        feature.setRegistryName(new ResourceLocation("atum", name));
        FEATURES.add(feature);
        return feature;
    }

    @SubscribeEvent
    public static void registerFeature(RegistryEvent.Register<Feature<?>> event) {
        for (Feature<?> feature : FEATURES) {
            event.getRegistry().register(feature);
        }
    }
}

