/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.teammetallurgy.atum.api.recipe.RotationRecipe;
import com.teammetallurgy.atum.api.recipe.recipes.KilnRecipe;
import com.teammetallurgy.atum.api.recipe.recipes.QuernRecipe;
import com.teammetallurgy.atum.api.recipe.recipes.SpinningWheelRecipe;
import com.teammetallurgy.atum.misc.recipe.MapExtendingScrollRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="atum", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="atum")
public class AtumRecipeSerializers {
    private static final List<IRecipeSerializer<?>> SERIALIZERS = new ArrayList();
    public static final SpecialRecipeSerializer<MapExtendingScrollRecipe> MAP_EXTENDING_SCROLL = AtumRecipeSerializers.register("map_extending_scroll", new SpecialRecipeSerializer(MapExtendingScrollRecipe::new));
    public static final KilnRecipe.Serializer<KilnRecipe> KILN = AtumRecipeSerializers.register("kiln", new KilnRecipe.Serializer<KilnRecipe>(KilnRecipe::new, 75));
    public static final RotationRecipe.Serializer<QuernRecipe> QUERN = AtumRecipeSerializers.register("quern", new RotationRecipe.Serializer<QuernRecipe>(QuernRecipe::new, false));
    public static final RotationRecipe.Serializer<SpinningWheelRecipe> SPINNING_WHEEL = AtumRecipeSerializers.register("spinning_wheel", new RotationRecipe.Serializer<SpinningWheelRecipe>(SpinningWheelRecipe::new, true));

    private static <S extends IRecipeSerializer<T>, T extends IRecipe<?>> S register(String name, S recipeSerializer) {
        recipeSerializer.setRegistryName(new ResourceLocation("atum", name));
        SERIALIZERS.add(recipeSerializer);
        return recipeSerializer;
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        for (IRecipeSerializer<?> serializer : SERIALIZERS) {
            event.getRegistry().register(serializer);
        }
    }
}

