/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.jei.categories;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.teammetallurgy.atum.api.recipe.recipes.QuernRecipe;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.integration.jei.JEIIntegration;
import java.awt.Color;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class QuernRecipeCategory
implements IRecipeCategory<QuernRecipe> {
    private static final ResourceLocation QUERN_GUI = new ResourceLocation("atum", "textures/gui/quern.png");
    private final IDrawableStatic background;
    private final IDrawable icon;

    public QuernRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(QUERN_GUI, 0, -6, 82, 32);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)AtumBlocks.QUERN));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return JEIIntegration.QUERN;
    }

    @Nonnull
    public Class<? extends QuernRecipe> getRecipeClass() {
        return QuernRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return new TranslationTextComponent("atum." + this.getUid().func_110623_a()).getString();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull QuernRecipe recipe, @Nonnull IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull QuernRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 10);
        guiItemStacks.init(1, false, 60, 10);
        guiItemStacks.set(ingredients);
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex == 1) {
                boolean showAdvanced;
                boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || Screen.func_231173_s_();
                if (showAdvanced) {
                    tooltip.add(new TranslationTextComponent("jei.tooltip.recipe.id", new Object[]{recipe.func_199560_c()}).func_240699_a_(TextFormatting.DARK_GRAY));
                }
            }
        });
    }

    public void draw(QuernRecipe recipe, @Nonnull MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft.func_71410_x().field_71466_p.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("gui.atum.rotations", new Object[]{recipe.getRotations()}), 32.0f, 0.0f, Color.gray.getRGB());
        this.icon.draw(matrixStack, 29, 8);
    }
}

