/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.waila;

import com.teammetallurgy.atum.blocks.base.DoorAtumBlock;
import com.teammetallurgy.atum.blocks.vegetation.DateBlock;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class WailaHUDHandler
implements IComponentProvider {
    static final WailaHUDHandler INSTANCE = new WailaHUDHandler();

    @Nonnull
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        ResourceLocation location;
        if (accessor.getBlock() instanceof DoorAtumBlock && config.get(new ResourceLocation("hide_infestations")) && (location = accessor.getBlock().getRegistryName()) != null && location.toString().contains("limestone")) {
            location = new ResourceLocation(location.toString().replace("_door", ""));
            return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(location));
        }
        return accessor.getStack();
    }

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() instanceof DateBlock && config.get(new ResourceLocation("crop_progress"))) {
            WailaHUDHandler.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().func_177229_b((Property)DateBlock.AGE)).intValue() / 7.0f);
        }
    }

    private static void addMaturityTooltip(List<ITextComponent> tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.crop_growth", new Object[]{String.format("%.0f%%", Float.valueOf(growthValue))}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.crop_growth", new Object[]{new TranslationTextComponent("tooltip.waila.crop_mature")}));
        }
    }
}

