/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts.atem;

import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.api.IArtifact;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumParticles;
import com.teammetallurgy.atum.items.tools.AtumShieldItem;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class AtemsProtectionItem
extends AtumShieldItem
implements IArtifact {
    private static final Object2BooleanMap<LivingEntity> IS_BLOCKING = new Object2BooleanOpenHashMap();
    protected static final Object2IntMap<LivingEntity> TIMER = new Object2IntOpenHashMap();

    public AtemsProtectionItem() {
        super(600, new Item.Properties().func_208103_a(Rarity.RARE));
        this.setRepairItem(AtumItems.NEBU_INGOT);
    }

    @Override
    public God getGod() {
        return God.ATEM;
    }

    public void func_219972_a(@Nonnull World world, @Nonnull LivingEntity livingEntity, @Nonnull ItemStack stack, int count) {
        super.func_219972_a(world, livingEntity, stack, count);
        IS_BLOCKING.putIfAbsent((Object)livingEntity, true);
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull LivingEntity livingEntity, int timeLeft) {
        super.func_77615_a(stack, world, livingEntity, timeLeft);
        IS_BLOCKING.removeBoolean((Object)livingEntity);
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (TIMER.containsKey((Object)event.getEntityLiving())) {
            LivingEntity livingEntity = event.getEntityLiving();
            int timer = TIMER.getInt((Object)livingEntity);
            if (timer == 0) {
                TIMER.removeInt((Object)livingEntity);
            }
            if (timer > 0) {
                TIMER.replace((Object)livingEntity, timer - 1);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingHurtEvent event) {
        Entity source = event.getSource().func_76364_f();
        LivingEntity livingEntity = event.getEntityLiving();
        if (source instanceof LivingEntity && IS_BLOCKING.containsKey((Object)livingEntity) && IS_BLOCKING.getBoolean((Object)livingEntity)) {
            if (field_77697_d.nextDouble() <= 0.2) {
                TIMER.put((Object)livingEntity, 200);
                if (livingEntity.field_70170_p instanceof ServerWorld) {
                    ServerWorld serverWorld = (ServerWorld)livingEntity.field_70170_p;
                    serverWorld.func_195598_a((IParticleData)AtumParticles.LIGHT_SPARKLE, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_() + 1.0, livingEntity.func_226281_cx_(), 40, 0.1, 0.0, 0.1, 0.01);
                }
            }
            IS_BLOCKING.removeBoolean((Object)livingEntity);
        }
        if (TIMER.containsKey((Object)livingEntity)) {
            event.setAmount(0.0f);
        }
    }
}

