/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts.nepthys;

import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.api.IArtifact;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumParticles;
import com.teammetallurgy.atum.items.tools.AtumShieldItem;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class NepthysConsecrationItem
extends AtumShieldItem
implements IArtifact {
    private static final Object2BooleanMap<LivingEntity> IS_BLOCKING = new Object2BooleanOpenHashMap();

    public NepthysConsecrationItem() {
        super(500, new Item.Properties().func_208103_a(Rarity.RARE));
        this.setRepairItem(AtumItems.NEBU_INGOT);
    }

    @Override
    public God getGod() {
        return God.NEPTHYS;
    }

    public void func_219972_a(@Nonnull World world, @Nonnull LivingEntity livingEntity, @Nonnull ItemStack stack, int count) {
        super.func_219972_a(world, livingEntity, stack, count);
        IS_BLOCKING.putIfAbsent((Object)livingEntity, true);
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull LivingEntity livingEntity, int timeLeft) {
        super.func_77615_a(stack, world, livingEntity, timeLeft);
        IS_BLOCKING.removeBoolean((Object)livingEntity);
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        Entity source = event.getSource().func_76364_f();
        LivingEntity livingEntity = event.getEntityLiving();
        if (source instanceof LivingEntity && IS_BLOCKING.containsKey((Object)livingEntity) && ((LivingEntity)source).func_70668_bt() == CreatureAttribute.field_223223_b_) {
            source.func_70015_d(8);
            source.func_70097_a(DamageSource.field_76377_j, 2.0f);
            if (livingEntity.field_70170_p instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)livingEntity.field_70170_p;
                serverWorld.func_195598_a((IParticleData)AtumParticles.LIGHT_SPARKLE, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_() + 1.0, livingEntity.func_226281_cx_(), 40, 0.1, 0.0, 0.1, 0.01);
            }
            IS_BLOCKING.removeBoolean((Object)livingEntity);
        }
    }
}

