/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts.nuit;

import com.teammetallurgy.atum.api.AtumMats;
import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.api.IArtifact;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumParticles;
import com.teammetallurgy.atum.items.tools.KhopeshItem;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class NuitsQuarterItem
extends KhopeshItem
implements IArtifact {
    private boolean isOffhand = false;
    private static final Object2BooleanMap<LivingEntity> IS_BLOCKING = new Object2BooleanOpenHashMap();

    public NuitsQuarterItem() {
        super(AtumMats.NEBU, new Item.Properties().func_208103_a(Rarity.RARE));
    }

    @Override
    public God getGod() {
        return God.NUIT;
    }

    @Nonnull
    public UseAction func_77661_b(@Nonnull ItemStack stack) {
        return UseAction.BLOCK;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return this.isOffhand ? 72000 : 0;
    }

    public boolean isShield(@Nonnull ItemStack stack, @Nullable LivingEntity entity) {
        return this.isOffhand;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        if (hand == Hand.OFF_HAND) {
            player.func_184598_c(Hand.OFF_HAND);
            this.isOffhand = true;
            return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(Hand.OFF_HAND));
        }
        this.isOffhand = false;
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity attacker) {
        if (field_77697_d.nextFloat() <= 0.25f) {
            NuitsQuarterItem.applyWeakness(target, attacker, attacker.func_184592_cb().func_77973_b() == AtumItems.NUITS_IRE);
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public void func_219972_a(@Nonnull World world, @Nonnull LivingEntity livingEntity, @Nonnull ItemStack stack, int count) {
        super.func_219972_a(world, livingEntity, stack, count);
        IS_BLOCKING.putIfAbsent((Object)livingEntity, true);
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull LivingEntity livingEntity, int timeLeft) {
        super.func_77615_a(stack, world, livingEntity, timeLeft);
        IS_BLOCKING.removeBoolean((Object)livingEntity);
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        Entity trueSource = event.getSource().func_76364_f();
        LivingEntity livingEntity = event.getEntityLiving();
        if (trueSource instanceof LivingEntity && livingEntity instanceof PlayerEntity && IS_BLOCKING.getBoolean((Object)livingEntity) && field_77697_d.nextFloat() <= 0.25f) {
            NuitsQuarterItem.applyWeakness((LivingEntity)trueSource, event.getEntityLiving(), event.getEntityLiving().func_184614_ca().func_77973_b() == AtumItems.NUITS_IRE);
            IS_BLOCKING.removeBoolean((Object)livingEntity);
        }
    }

    private static void applyWeakness(LivingEntity target, LivingEntity attacker, boolean isNuitsIreHeld) {
        if (attacker != target) {
            if (target.field_70170_p instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)target.field_70170_p;
                serverWorld.func_195598_a((IParticleData)AtumParticles.NUIT_BLACK, target.func_226277_ct_() + (field_77697_d.nextDouble() - 0.5) * (double)target.func_213311_cf(), target.func_226278_cu_() + (double)target.func_213302_cg() / 1.5, target.func_226281_cx_() + (field_77697_d.nextDouble() - 0.5) * (double)target.func_213311_cf(), 8, 0.01, 0.0, 0.01, 0.02);
            }
            target.func_195064_c(new EffectInstance(Effects.field_76437_t, 60, isNuitsIreHeld ? 2 : 1));
        }
    }
}

