/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts.nuit;

import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.api.IArtifact;
import com.teammetallurgy.atum.items.artifacts.AmuletItem;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class NuitsVanishingItem
extends AmuletItem
implements IArtifact {
    protected static final Object2BooleanMap<LivingEntity> INVISIBLE = new Object2BooleanOpenHashMap();

    public NuitsVanishingItem() {
        super(new Item.Properties());
    }

    @Override
    public God getGod() {
        return God.NUIT;
    }

    @SubscribeEvent
    public static void onTarget(LivingSetAttackTargetEvent event) {
        if (INVISIBLE.getBoolean((Object)event.getTarget()) && event.getTarget() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity) {
            ((MobEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @Override
    public void onUnequip(String identifier, int index, LivingEntity livingEntity, @Nonnull ItemStack stack) {
        this.setNotInvisible(livingEntity);
    }

    @Override
    public void curioBreak(@Nonnull ItemStack stack, LivingEntity livingEntity) {
        this.setNotInvisible(livingEntity);
    }

    @Override
    public void curioTick(String identifier, int index, LivingEntity livingEntity, @Nonnull ItemStack stack) {
        World world = livingEntity.func_130014_f_();
        INVISIBLE.putIfAbsent((Object)livingEntity, true);
        if (!NuitsVanishingItem.isLivingEntityMoving(livingEntity)) {
            INVISIBLE.replace((Object)livingEntity, true);
            if (!world.field_72995_K) {
                livingEntity.func_82142_c(true);
            }
        } else {
            this.setNotInvisible(livingEntity);
        }
    }

    public void setNotInvisible(LivingEntity livingEntity) {
        INVISIBLE.replace((Object)livingEntity, false);
        if (!livingEntity.func_130014_f_().field_72995_K && !livingEntity.func_70644_a(Effects.field_76441_p) && livingEntity.func_82150_aj()) {
            livingEntity.func_82142_c(false);
        }
    }

    public static boolean isLivingEntityMoving(LivingEntity livingEntity) {
        return livingEntity.field_70140_Q != livingEntity.field_70141_P || livingEntity.func_213453_ef();
    }
}

