/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts.osiris;

import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.api.IArtifact;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumParticles;
import com.teammetallurgy.atum.items.artifacts.AmuletItem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="atum")
public class OsirisMercyItem
extends AmuletItem
implements IArtifact {
    public OsirisMercyItem() {
        super(new Item.Properties().func_200918_c(1000));
    }

    @Override
    public God getGod() {
        return God.OSIRIS;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return false;
    }

    @SubscribeEvent
    public static void onCuriosDrop(DropRulesEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            CompoundNBT playerData = OsirisMercyItem.getPlayerData(player);
            if (!player.field_70170_p.field_72995_K && playerData.func_74764_b("Inventory")) {
                CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(handler -> {
                    int i = 0;
                    while (i < handler.getSlots()) {
                        int finalI = i++;
                        event.addOverride(stack -> stack == handler.getStackInSlot(finalI), ICurio.DropRule.ALWAYS_KEEP);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        Optional optional = CuriosApi.getCuriosHelper().findEquippedCurio(AtumItems.OSIRIS_MERCY, livingEntity);
        if (optional.isPresent() && event.getEntityLiving() instanceof PlayerEntity) {
            ItemStack anubisMercy = (ItemStack)((ImmutableTriple)optional.get()).getRight();
            PlayerEntity player = (PlayerEntity)livingEntity;
            if (!player.field_70170_p.field_72995_K) {
                anubisMercy.func_222118_a(334, (LivingEntity)player, e -> e.func_213334_d(e.func_184600_cs()));
                ListNBT tagList = new ListNBT();
                player.field_71071_by.func_70442_a(tagList);
                OsirisMercyItem.getPlayerData(player).func_218657_a("Inventory", (INBT)tagList);
                player.field_71071_by.field_70462_a.clear();
                player.field_71071_by.field_70460_b.clear();
                player.field_71071_by.field_184439_c.clear();
            }
            if (player.field_70170_p instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)player.field_70170_p;
                double y = MathHelper.func_82716_a((Random)field_77697_d, (double)0.01, (double)0.1);
                serverWorld.func_195598_a((IParticleData)AtumParticles.ANUBIS_SKULL, player.func_226277_ct_() + (field_77697_d.nextDouble() - 0.5) * (double)player.func_213311_cf(), player.func_226278_cu_() + 1.0, player.func_226281_cx_() + (field_77697_d.nextDouble() - 0.5) * (double)player.func_213311_cf(), 22, 0.04, y, 0.0, 0.075);
                serverWorld.func_195598_a((IParticleData)AtumParticles.ANUBIS_SKULL, player.func_226277_ct_() + (field_77697_d.nextDouble() - 0.5) * (double)player.func_213311_cf(), player.func_226278_cu_() + 1.0, player.func_226281_cx_() + (field_77697_d.nextDouble() - 0.5) * (double)player.func_213311_cf(), 22, 0.0, y, 0.04, 0.075);
                serverWorld.func_195598_a((IParticleData)AtumParticles.ANUBIS_SKULL, player.func_226277_ct_() + (field_77697_d.nextDouble() - 0.5) * (double)player.func_213311_cf(), player.func_226278_cu_() + 1.0, player.func_226281_cx_() + (field_77697_d.nextDouble() - 0.5) * (double)player.func_213311_cf(), 22, -0.04, y, 0.0, 0.075);
                serverWorld.func_195598_a((IParticleData)AtumParticles.ANUBIS_SKULL, player.func_226277_ct_() + (field_77697_d.nextDouble() - 0.5) * (double)player.func_213311_cf(), player.func_226278_cu_() + 1.0, player.func_226281_cx_() + (field_77697_d.nextDouble() - 0.5) * (double)player.func_213311_cf(), 22, 0.0, y, -0.04, 0.075);
            }
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187553_bI, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity player = event.getPlayer();
        CompoundNBT playerData = OsirisMercyItem.getPlayerData(player);
        if (!player.field_70170_p.field_72995_K && playerData.func_74764_b("Inventory")) {
            ListNBT tagList = playerData.func_150295_c("Inventory", 10);
            player.field_71071_by.func_70443_b(tagList);
            OsirisMercyItem.getPlayerData(player).func_82580_o("Inventory");
        }
    }

    private static CompoundNBT getPlayerData(PlayerEntity player) {
        if (!player.getPersistentData().func_74764_b("PlayerPersisted")) {
            player.getPersistentData().func_218657_a("PlayerPersisted", (INBT)new CompoundNBT());
        }
        return player.getPersistentData().func_74775_l("PlayerPersisted");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, @Nonnull ITooltipFlag tooltipType) {
        int remaining = (stack.func_77958_k() - stack.func_77952_i()) / 332;
        tooltip.add((ITextComponent)new TranslationTextComponent("atum.tooltip.uses_remaining", new Object[]{remaining}));
        tooltip.add((ITextComponent)new TranslationTextComponent("atum." + Objects.requireNonNull(this.getRegistryName()).func_110623_a() + ".disenchantment_curse").func_240699_a_(TextFormatting.DARK_RED));
    }
}

