/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.tools;

import com.teammetallurgy.atum.Atum;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.SwordItem;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class HammerItem
extends SwordItem {
    private static final AttributeModifier STUN_MODIFIER = new AttributeModifier(UUID.fromString("b4ebf092-fe62-4250-b945-7dc45b2f1036"), "Hammer stun", -1000.0, AttributeModifier.Operation.ADDITION);
    private static final Object2FloatMap<PlayerEntity> COOLDOWN = new Object2FloatOpenHashMap();
    protected static final Object2IntMap<LivingEntity> STUN = new Object2IntOpenHashMap();

    protected HammerItem(IItemTier tier, Item.Properties properties) {
        super(tier, 17, -3.55f, properties.func_200916_a(Atum.GROUP));
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        Entity trueSource = event.getSource().func_76346_g();
        if (trueSource instanceof PlayerEntity && COOLDOWN.containsKey((Object)trueSource)) {
            Item heldItem;
            if (COOLDOWN.getFloat((Object)trueSource) == 1.0f && (heldItem = ((PlayerEntity)trueSource).func_184614_ca().func_77973_b()) instanceof HammerItem) {
                HammerItem hammerItem = (HammerItem)heldItem;
                LivingEntity target = event.getEntityLiving();
                ModifiableAttributeInstance attribute = target.func_110148_a(Attributes.field_233821_d_);
                if (attribute != null && !attribute.func_180374_a(STUN_MODIFIER)) {
                    attribute.func_233767_b_(STUN_MODIFIER);
                    hammerItem.onStun(target);
                }
            }
            COOLDOWN.removeFloat((Object)trueSource);
        }
    }

    protected void onStun(LivingEntity target) {
        STUN.put((Object)target, 40);
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (STUN.isEmpty()) {
            return;
        }
        ModifiableAttributeInstance attribute = entity.func_110148_a(Attributes.field_233821_d_);
        if (attribute != null && attribute.func_180374_a(STUN_MODIFIER)) {
            int stunTime = STUN.getInt((Object)entity);
            if (stunTime <= 1) {
                attribute.func_111124_b(STUN_MODIFIER);
                STUN.remove((Object)entity, stunTime);
            } else {
                STUN.replace((Object)entity, stunTime - 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAttack(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (event.getTarget() instanceof LivingEntity && player.func_184614_ca().func_77973_b() instanceof HammerItem) {
            COOLDOWN.put((Object)player, player.func_184825_o(0.5f));
        }
    }
}

