/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.misc.datagenerator;

import com.teammetallurgy.atum.blocks.lighting.AtumTorchUnlitBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.misc.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStatesGenerator
extends BlockStateProvider {
    public BlockStatesGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "atum", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.generateTorchWithUnlit(AtumBlocks.PALM_TORCH);
        this.generateTorchWithUnlit(AtumBlocks.DEADWOOD_TORCH);
        this.generateTorchWithUnlit(AtumBlocks.LIMESTONE_TORCH);
        this.generateTorchWithUnlit(AtumBlocks.BONE_TORCH);
        this.generateTorchWithUnlit(AtumBlocks.NEBU_TORCH);
        this.generateTorch(AtumBlocks.TORCH_OF_ANPUT);
        this.generateTorch(AtumBlocks.TORCH_OF_ANUBIS);
        this.generateTorch(AtumBlocks.TORCH_OF_ATEM);
        this.generateTorch(AtumBlocks.TORCH_OF_GEB);
        this.generateTorch(AtumBlocks.TORCH_OF_HORUS);
        this.generateTorch(AtumBlocks.TORCH_OF_ISIS);
        this.generateTorch(AtumBlocks.TORCH_OF_MONTU);
        this.generateTorch(AtumBlocks.TORCH_OF_NEPTHYS);
        this.generateTorch(AtumBlocks.TORCH_OF_NUIT);
        this.generateTorch(AtumBlocks.TORCH_OF_OSIRIS);
        this.generateTorch(AtumBlocks.TORCH_OF_PTAH);
        this.generateTorch(AtumBlocks.TORCH_OF_RA);
        this.generateTorch(AtumBlocks.TORCH_OF_SETH);
        this.generateTorch(AtumBlocks.TORCH_OF_SHU);
        this.generateTorch(AtumBlocks.TORCH_OF_TEFNUT);
        this.wallBlock(AtumBlocks.LIMESTONE_WALL, AtumBlocks.LIMESTONE);
        this.wallBlock(AtumBlocks.LIMESTONE_CRACKED_WALL, AtumBlocks.LIMESTONE_CRACKED);
        this.wallBlock(AtumBlocks.SMALL_WALL, AtumBlocks.LIMESTONE_BRICK_SMALL);
        this.wallBlock(AtumBlocks.LARGE_WALL, AtumBlocks.LIMESTONE_BRICK_LARGE);
        this.wallBlock(AtumBlocks.CRACKED_BRICK_WALL, this.modLoc("block/limestone_brick_cracked"));
        this.wallBlock(AtumBlocks.CHISELED_WALL, AtumBlocks.LIMESTONE_BRICK_CHISELED);
        this.wallBlock(AtumBlocks.CARVED_WALL, AtumBlocks.LIMESTONE_BRICK_CARVED);
        this.wallBlock(AtumBlocks.ALABASTER_BRICK_SMOOTH_WALL, AtumBlocks.ALABASTER_BRICK_SMOOTH);
        this.wallBlock(AtumBlocks.ALABASTER_BRICK_POLISHED_WALL, AtumBlocks.ALABASTER_BRICK_POLISHED);
        this.wallBlock(AtumBlocks.ALABASTER_BRICK_CARVED_WALL, AtumBlocks.ALABASTER_BRICK_CARVED);
        this.wallBlock(AtumBlocks.ALABASTER_BRICK_TILED_WALL, AtumBlocks.ALABASTER_BRICK_TILED);
        this.wallBlock(AtumBlocks.ALABASTER_BRICK_PILLAR_WALL, AtumBlocks.ALABASTER_BRICK_PILLAR);
        this.wallBlock(AtumBlocks.PORPHYRY_BRICK_SMOOTH_WALL, AtumBlocks.PORPHYRY_BRICK_SMOOTH);
        this.wallBlock(AtumBlocks.PORPHYRY_BRICK_POLISHED_WALL, AtumBlocks.PORPHYRY_BRICK_POLISHED);
        this.wallBlock(AtumBlocks.PORPHYRY_BRICK_CARVED_WALL, AtumBlocks.PORPHYRY_BRICK_CARVED);
        this.wallBlock(AtumBlocks.PORPHYRY_BRICK_TILED_WALL, AtumBlocks.PORPHYRY_BRICK_TILED);
        this.wallBlock(AtumBlocks.PORPHYRY_BRICK_PILLAR_WALL, AtumBlocks.PORPHYRY_BRICK_PILLAR);
        this.wallBlock(AtumBlocks.CERAMIC_WHITE_WALL, AtumBlocks.CERAMIC_WHITE);
        this.wallBlock(AtumBlocks.CERAMIC_ORANGE_WALL, AtumBlocks.CERAMIC_ORANGE);
        this.wallBlock(AtumBlocks.CERAMIC_MAGENTA_WALL, AtumBlocks.CERAMIC_MAGENTA);
        this.wallBlock(AtumBlocks.CERAMIC_LIGHT_BLUE_WALL, AtumBlocks.CERAMIC_LIGHT_BLUE);
        this.wallBlock(AtumBlocks.CERAMIC_YELLOW_WALL, AtumBlocks.CERAMIC_YELLOW);
        this.wallBlock(AtumBlocks.CERAMIC_LIME_WALL, AtumBlocks.CERAMIC_LIME);
        this.wallBlock(AtumBlocks.CERAMIC_PINK_WALL, AtumBlocks.CERAMIC_PINK);
        this.wallBlock(AtumBlocks.CERAMIC_GRAY_WALL, AtumBlocks.CERAMIC_GRAY);
        this.wallBlock(AtumBlocks.CERAMIC_LIGHT_GRAY_WALL, AtumBlocks.CERAMIC_LIGHT_GRAY);
        this.wallBlock(AtumBlocks.CERAMIC_CYAN_WALL, AtumBlocks.CERAMIC_CYAN);
        this.wallBlock(AtumBlocks.CERAMIC_PURPLE_WALL, AtumBlocks.CERAMIC_PURPLE);
        this.wallBlock(AtumBlocks.CERAMIC_BLUE_WALL, AtumBlocks.CERAMIC_BLUE);
        this.wallBlock(AtumBlocks.CERAMIC_BROWN_WALL, AtumBlocks.CERAMIC_BROWN);
        this.wallBlock(AtumBlocks.CERAMIC_GREEN_WALL, AtumBlocks.CERAMIC_GREEN);
        this.wallBlock(AtumBlocks.CERAMIC_RED_WALL, AtumBlocks.CERAMIC_RED);
        this.wallBlock(AtumBlocks.CERAMIC_BLACK_WALL, AtumBlocks.CERAMIC_BLACK);
        this.simpleBlockWithItem(AtumBlocks.CRYSTAL_GLASS);
        this.simpleBlockWithItem(AtumBlocks.PALM_FRAMED_CRYSTAL_GLASS);
        this.simpleBlockWithItem(AtumBlocks.DEADWOOD_FRAMED_CRYSTAL_GLASS);
        this.paneBlockWithItem((PaneBlock)AtumBlocks.CRYSTAL_GLASS_PANE, new ResourceLocation("atum", "block/crystal_glass"), new ResourceLocation("atum", "block/crystal_glass_pane_top"));
        this.paneBlockWithItem((PaneBlock)AtumBlocks.PALM_FRAMED_CRYSTAL_GLASS_PANE, new ResourceLocation("atum", "block/palm_framed_crystal_glass"), new ResourceLocation("atum", "block/palm_framed_crystal_glass_pane_top"));
        this.paneBlockWithItem((PaneBlock)AtumBlocks.DEADWOOD_FRAMED_CRYSTAL_GLASS_PANE, new ResourceLocation("atum", "block/deadwood_framed_crystal_glass"), new ResourceLocation("atum", "block/deadwood_framed_crystal_glass_pane_top"));
        for (DyeColor color : DyeColor.values()) {
            String colorName = color.func_176610_l();
            this.simpleBlockWithItem(StackHelper.getBlockFromName(colorName + "_stained_crystal_glass"));
            this.simpleBlockWithItem(StackHelper.getBlockFromName(colorName + "_stained_palm_framed_crystal_glass"));
            this.simpleBlockWithItem(StackHelper.getBlockFromName(colorName + "_stained_deadwood_framed_crystal_glass"));
            this.paneBlockWithItem((PaneBlock)StackHelper.getBlockFromName(colorName + "_stained_crystal_glass_pane"), new ResourceLocation("atum", "block/" + colorName + "_stained_crystal_glass"), new ResourceLocation("atum", "block/" + colorName + "_stained_crystal_glass_pane_top"));
            this.paneBlockWithItem((PaneBlock)StackHelper.getBlockFromName(colorName + "_stained_palm_framed_crystal_glass_pane"), new ResourceLocation("atum", "block/" + colorName + "_stained_palm_framed_crystal_glass"), new ResourceLocation("atum", "block/palm_framed_crystal_glass_pane_top"));
            this.paneBlockWithItem((PaneBlock)StackHelper.getBlockFromName(colorName + "_stained_deadwood_framed_crystal_glass_pane"), new ResourceLocation("atum", "block/" + colorName + "_stained_deadwood_framed_crystal_glass"), new ResourceLocation("atum", "block/deadwood_framed_crystal_glass_pane_top"));
        }
    }

    private void generateTorch(Block torch) {
        String torchName = torch.getRegistryName().func_110623_a();
        ResourceLocation wallTorchName = new ResourceLocation("atum", "wall_" + torchName);
        ResourceLocation torchLocation = new ResourceLocation("atum", "block/" + torchName);
        this.simpleBlock(torch, (ModelFile)this.models().torch(torchName, torchLocation));
        this.horizontalBlock(StackHelper.getBlockFromName(wallTorchName), (ModelFile)this.models().torchWall("wall_" + torchName, new ResourceLocation("atum", "block/" + torchName)), 90);
        ((ItemModelBuilder)((ItemModelBuilder)super.itemModels().getBuilder(torch.getRegistryName().func_110623_a())).parent((ModelFile)this.itemModels().getExistingFile(new ResourceLocation("item/generated")))).texture("layer0", torchLocation);
        ((ItemModelBuilder)((ItemModelBuilder)super.itemModels().getBuilder(wallTorchName.func_110623_a())).parent((ModelFile)this.itemModels().getExistingFile(new ResourceLocation("item/generated")))).texture("layer0", torchLocation);
    }

    private void generateTorchWithUnlit(Block torch) {
        String torchName = torch.getRegistryName().func_110623_a();
        this.generateTorch(torch);
        ResourceLocation unlitTorchLocation = new ResourceLocation("atum", "block/" + torchName + "_unlit");
        this.simpleBlock((Block)AtumTorchUnlitBlock.UNLIT.get(torch), (ModelFile)this.models().torch(torchName + "_unlit", unlitTorchLocation));
        this.horizontalBlock(StackHelper.getBlockFromName(new ResourceLocation("atum", "wall_" + torchName + "_unlit")), (ModelFile)this.models().torchWall("wall_" + torchName + "_unlit", new ResourceLocation("atum", "block/" + torchName + "_unlit")), 90);
    }

    private void wallBlock(WallBlock wallBlock, Block textureBlock) {
        super.wallBlock(wallBlock, this.modLoc("block/" + textureBlock.getRegistryName().func_110623_a()));
    }

    private void simpleBlockWithItem(Block block) {
        super.simpleBlock(block);
        super.simpleBlockItem(block, this.cubeAll(block));
    }

    private void paneBlockWithItem(PaneBlock block, ResourceLocation pane, ResourceLocation edge) {
        super.paneBlock(block, pane, edge);
        ((ItemModelBuilder)((ItemModelBuilder)super.itemModels().getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.itemModels().getExistingFile(new ResourceLocation("item/generated")))).texture("layer0", pane);
    }
}

