/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.misc.recipe;

import com.teammetallurgy.atum.api.recipe.recipes.KilnRecipe;
import com.teammetallurgy.atum.blocks.machines.tileentity.KilnTileEntity;
import com.teammetallurgy.atum.misc.StackHelper;
import com.teammetallurgy.atum.misc.recipe.BrewingNBT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class RecipeHelper {
    public static void addBrewingRecipeWithSubPotions(ItemStack stack, Potion potionType) {
        RecipeHelper.addBrewingRecipeWithSubPotions(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack}), potionType);
    }

    public static void addBrewingRecipeWithSubPotions(Tags.IOptionalNamedTag<Item> tag, Potion potionType) {
        RecipeHelper.addBrewingRecipeWithSubPotions(Ingredient.func_199805_a(tag), potionType);
    }

    public static void addBrewingRecipeWithSubPotions(Ingredient ingredient, Potion potionType) {
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b), ingredient, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185231_c));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185233_e), ingredient, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)potionType));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_185233_e), ingredient, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)potionType));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_185230_b), ingredient, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_185231_c));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)Potions.field_185230_b), ingredient, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)Potions.field_185231_c));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)Potions.field_185233_e), ingredient, PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)potionType));
    }

    public static boolean addRecipe(@Nonnull ItemStack input, @Nonnull ItemStack ingredient, @Nonnull ItemStack output) {
        return RecipeHelper.addRecipe(input, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ingredient}), output);
    }

    public static boolean addRecipe(@Nonnull ItemStack input, @Nonnull Ingredient ingredient, @Nonnull ItemStack output) {
        return BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingNBT(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), ingredient, output));
    }

    public static <C extends IInventory, T extends IRecipe<C>> Collection<T> getRecipes(RecipeManager recipeManager, IRecipeType<T> recipeType) {
        Map recipesMap = recipeManager.func_215366_a(recipeType);
        return recipesMap.values();
    }

    public static <C extends IInventory, T extends IRecipe<C>> boolean isItemValidForSlot(World world, @Nonnull ItemStack stack, IRecipeType<T> recipeType) {
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            Collection<IRecipe> recipes = RecipeHelper.getRecipes(serverWorld.func_199532_z(), recipeType);
            for (IRecipe recipe : recipes) {
                for (Ingredient ingredient : recipe.func_192400_c()) {
                    if (!StackHelper.areIngredientsEqualIgnoreSize(ingredient, stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static <C extends IInventory, T extends IRecipe<C>> Boolean isValidRecipeInput(Collection<T> recipes, @Nonnull ItemStack input) {
        for (IRecipe recipe : recipes) {
            for (Ingredient ingredient : recipe.func_192400_c()) {
                if (!StackHelper.areIngredientsEqualIgnoreSize(ingredient, input)) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection<KilnRecipe> getKilnRecipesFromFurnace(RecipeManager recipeManager) {
        ArrayList<KilnRecipe> kilnRecipes = new ArrayList<KilnRecipe>();
        for (FurnaceRecipe furnaceRecipe : RecipeHelper.getRecipes(recipeManager, IRecipeType.field_222150_b)) {
            for (Ingredient input : furnaceRecipe.func_192400_c()) {
                ItemStack output = furnaceRecipe.func_77571_b();
                if (input == null || output.func_190926_b() || KilnTileEntity.canKilnNotSmelt(input) || KilnTileEntity.canKilnNotSmelt(output)) continue;
                kilnRecipes.add(new KilnRecipe(input, output, furnaceRecipe.func_222138_b(), furnaceRecipe.func_222137_e()));
            }
        }
        return kilnRecipes;
    }
}

