/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.SandLayersBlock;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.AtumDimensionData;
import com.teammetallurgy.atum.world.gen.structure.StructureHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum")
public class DimensionHelper {
    public static final List<Block> SURFACE_BLOCKS = Lists.newArrayList((Object[])new Block[]{AtumBlocks.SAND, AtumBlocks.FERTILE_SOIL, AtumBlocks.LIMESTONE_GRAVEL});
    public static final int GROUND_LEVEL = 63;

    public static AtumDimensionData getData(ServerWorld serverWorld) {
        return (AtumDimensionData)serverWorld.func_217481_x().func_215752_a(AtumDimensionData::new, "atum_dimension_data");
    }

    @SubscribeEvent
    public static void onSleepFinished(SleepFinishedTimeEvent event) {
        ServerWorld serverWorld;
        IWorld world = event.getWorld();
        if (world instanceof ServerWorld && (serverWorld = (ServerWorld)world).func_234923_W_() == Atum.ATUM && world.func_72912_H() instanceof DerivedWorldInfo) {
            ((DerivedWorldInfo)world.func_72912_H()).field_76115_a.func_76068_b(event.getNewTime());
        }
    }

    public static int getSkyColorWithTemperatureModifier(float temperature) {
        float f = temperature / 3.0f;
        f = MathHelper.func_76131_a((float)f, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - f * 0.05f), (float)(0.5f + f * 0.1f), (float)1.0f);
    }

    public static boolean canPlaceSandLayer(ISeedReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        BlockState stateDown = world.func_180495_p(pos.func_177977_b());
        Optional biomeKey = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)world.func_226691_t_(pos));
        return biomeKey.isPresent() && biomeKey.get() != AtumBiomes.OASIS && !StructureHelper.doesChunkHaveStructure(world, pos, Structure.field_236381_q_) && world.func_175623_d(pos.func_177984_a()) && state.func_185904_a().func_76222_j() && stateDown.func_177230_c() != AtumBlocks.LIMESTONE_CRACKED && Block.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b()) && !(stateDown.func_177230_c() instanceof SandLayersBlock) && !(state.func_177230_c() instanceof SandLayersBlock);
    }

    public static BlockPos getSurfacePos(World world, BlockPos pos) {
        while (pos.func_177956_o() > 1 && world.func_175623_d(pos.func_177977_b())) {
            pos = pos.func_177977_b();
        }
        while (!world.func_175623_d(pos.func_177984_a()) && (SURFACE_BLOCKS.contains(world.func_180495_p(pos.func_177977_b()).func_177230_c()) || world.func_180495_p(pos.func_177977_b()).func_177230_c() != AtumBlocks.SAND_LAYERED) || pos.func_177956_o() < 60) {
            pos = pos.func_177984_a();
        }
        return pos;
    }

    public static Biome getBiome(RegistryKey<Biome> key) {
        return (Biome)WorldGenRegistries.field_243657_i.func_230516_a_(key);
    }

    public static int getBiomeID(RegistryKey<Biome> key) {
        return WorldGenRegistries.field_243657_i.func_148757_b((Object)DimensionHelper.getBiome(key));
    }

    public static boolean isBeatenPyramid(ServerWorld serverWorld, MutableBoundingBox box2) {
        boolean validBox = false;
        for (MutableBoundingBox box1 : DimensionHelper.getData(serverWorld).getBeatenPyramids()) {
            if (box1.field_78897_a != box2.field_78897_a || box1.field_78895_b != box2.field_78895_b || box1.field_78896_c != box2.field_78896_c || box1.field_78893_d != box2.field_78893_d || box1.field_78894_e != box2.field_78894_e || box1.field_78892_f != box2.field_78892_f) continue;
            validBox = true;
            break;
        }
        return validBox;
    }
}

