/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.SandLayersBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.network.NetworkHandler;
import com.teammetallurgy.atum.network.packet.StormStrengthPacket;
import com.teammetallurgy.atum.network.packet.WeatherPacket;
import com.teammetallurgy.atum.world.DimensionHelper;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SandstormHandler {
    public static final SandstormHandler INSTANCE = new SandstormHandler();
    public int stormTime;
    public float prevStormStrength;
    public float stormStrength;
    private long lastUpdateTime;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld && DimensionHelper.getData((ServerWorld)event.getWorld()).isStorming()) {
            this.stormStrength = 1.0f;
        }
    }

    @SubscribeEvent
    public void onPreServerTick(TickEvent.WorldTickEvent event) {
        if (event.world.func_234923_W_() == Atum.ATUM) {
            this.updateWeather(event.world);
        }
    }

    private boolean canPlaceSandAt(ServerWorld serverWorld, BlockPos pos) {
        BlockState state = serverWorld.func_180495_p(pos.func_177977_b());
        return (state.func_177230_c() != AtumBlocks.SAND && state.func_177230_c() != AtumBlocks.LIMESTONE_GRAVEL || state.func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E)) && DimensionHelper.canPlaceSandLayer((ISeedReader)serverWorld, pos);
    }

    public void updateWeather(World world) {
        if (world instanceof ServerWorld && !world.field_72995_K) {
            ServerWorld serverWorld = (ServerWorld)world;
            IServerWorldInfo worldInfo = serverWorld.func_73046_m().func_240793_aU_().func_230407_G_();
            int cleanWeatherTime = worldInfo.func_230395_g_();
            if (cleanWeatherTime > 0) {
                --cleanWeatherTime;
                int n = this.stormTime = DimensionHelper.getData(serverWorld).isStorming() ? 1 : 2;
            }
            if (this.stormTime <= 0) {
                this.stormTime = DimensionHelper.getData(serverWorld).isStorming() ? serverWorld.field_73012_v.nextInt(6000) + 6000 : serverWorld.field_73012_v.nextInt(168000) + 12000;
                DimensionHelper.getData(serverWorld).setStorming(DimensionHelper.getData(serverWorld).isStorming());
                NetworkHandler.sendToDimension(new WeatherPacket(this.stormTime), serverWorld, Atum.ATUM);
            } else {
                --this.stormTime;
                if (this.stormTime <= 0) {
                    DimensionHelper.getData(serverWorld).setStorming(!DimensionHelper.getData(serverWorld).isStorming());
                }
            }
            worldInfo.func_230391_a_(cleanWeatherTime);
            this.prevStormStrength = this.stormStrength;
            this.stormStrength = DimensionHelper.getData(serverWorld).isStorming() ? (this.stormStrength += 1.0f / (float)(20 * (Integer)AtumConfig.SANDSTORM.sandstormTransitionTime.get())) : (this.stormStrength -= 1.0f / (float)(20 * (Integer)AtumConfig.SANDSTORM.sandstormTransitionTime.get()));
            this.stormStrength = MathHelper.func_76131_a((float)this.stormStrength, (float)0.0f, (float)1.0f);
            if (this.stormStrength != this.prevStormStrength || this.lastUpdateTime < System.currentTimeMillis() - 1000L) {
                NetworkHandler.sendToDimension(new StormStrengthPacket(this.stormStrength), serverWorld, Atum.ATUM);
                this.lastUpdateTime = System.currentTimeMillis();
            }
            try {
                if ((Integer)AtumConfig.SANDSTORM.sandstormSandLayerChance.get() > 0 && serverWorld.field_73012_v.nextInt((Integer)AtumConfig.SANDSTORM.sandstormSandLayerChance.get()) == 0 && this.stormStrength > 0.9f) {
                    ChunkManager chunkManager = serverWorld.getWorldServer().func_72863_F().field_217237_a;
                    chunkManager.func_223491_f().forEach(chunkHolder -> {
                        BlockPos pos;
                        BlockPos posDown;
                        ChunkPos chunkPos;
                        Optional optionalChunk = chunkHolder.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                        if (optionalChunk.isPresent() && !chunkManager.func_219243_d(chunkPos = ((Chunk)optionalChunk.get()).func_76632_l()) && serverWorld.isAreaLoaded(posDown = (pos = serverWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING, serverWorld.func_217383_a(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d(), 15))).func_177977_b(), 1)) {
                            BlockState sandState = serverWorld.func_180495_p(pos);
                            if (sandState.func_177230_c() == AtumBlocks.SAND_LAYERED) {
                                int layers = (Integer)sandState.func_177229_b((Property)SandLayersBlock.LAYERS);
                                if (layers < 3) {
                                    serverWorld.func_175656_a(pos, (BlockState)sandState.func_206870_a((Property)SandLayersBlock.LAYERS, (Comparable)Integer.valueOf(++layers)));
                                }
                            } else if (this.canPlaceSandAt(serverWorld, pos)) {
                                serverWorld.func_175656_a(pos, AtumBlocks.SAND_LAYERED.func_176223_P());
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                Atum.LOG.error("Error occurred while Sandstorm attempted to place Sand Layer");
            }
        }
    }
}

