/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.atum.misc.AtumRegistry;
import com.teammetallurgy.atum.world.gen.layer.AtumLayerUtil;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.layer.Layer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class AtumBiomeProvider
extends BiomeProvider {
    public static final Codec<AtumBiomeProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("large_biomes").orElse((Object)false).stable().forGetter(atumBiomeProvider -> atumBiomeProvider.largeBiomes), (App)RegistryLookupCodec.func_244331_a((RegistryKey)ForgeRegistries.Keys.BIOMES).forGetter(atumBiomeProvider -> atumBiomeProvider.lookupRegistry)).apply((Applicative)builder, builder.stable(AtumBiomeProvider::new)));
    private final Layer genBiomes;
    private final boolean largeBiomes;
    private final Registry<Biome> lookupRegistry;

    public AtumBiomeProvider(boolean largeBiomes, Registry<Biome> lookupRegistry) {
        super(AtumRegistry.BIOME_KEYS.stream().map(AtumBiomeProvider::getBiome).collect(Collectors.toList()));
        long seed = new Random().nextLong();
        this.largeBiomes = largeBiomes;
        this.lookupRegistry = lookupRegistry;
        this.genBiomes = AtumLayerUtil.getNoiseLayer(seed, largeBiomes ? 6 : 4, 6);
    }

    public static Biome getBiome(RegistryKey<Biome> key) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(key.func_240901_a_());
        if (biome == null) {
            throw new RuntimeException("Attempted to get unregistered biome " + key);
        }
        return biome;
    }

    @Nonnull
    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public BiomeProvider func_230320_a_(long seed) {
        return new AtumBiomeProvider(this.largeBiomes, this.lookupRegistry);
    }

    @Nonnull
    public Biome func_225526_b_(int x, int y, int z) {
        return this.genBiomes.func_242936_a(this.lookupRegistry, x, z);
    }
}

